/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.config;

import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContextBuilder;
import java.time.Duration;
import java.util.function.Consumer;

public abstract class NettyOptions<SO extends NettyOptions<? super SO>> {
    public static final boolean DEFAULT_MANAGED_PEER = Boolean.parseBoolean(System.getProperty("reactor.ipc.netty.managed.default", "false"));
    private long timeout = 30000L;
    private long sslHandshakeTimeoutMillis = 10000L;
    private boolean keepAlive = true;
    private int linger = 0;
    private boolean tcpNoDelay = true;
    private int rcvbuf = 0x100000;
    private int sndbuf = 0x100000;
    private boolean managed = DEFAULT_MANAGED_PEER;
    private Consumer<ChannelPipeline> pipelineConfigurer = null;
    private EventLoopGroup eventLoopGroup = null;
    private boolean daemon = true;
    private SslContextBuilder sslOptions = null;

    public boolean daemon() {
        return this.daemon;
    }

    public SO daemon(boolean daemon) {
        this.daemon = daemon;
        return (SO)this;
    }

    public EventLoopGroup eventLoopGroup() {
        return this.eventLoopGroup;
    }

    public SO eventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return (SO)this;
    }

    public boolean keepAlive() {
        return this.keepAlive;
    }

    public SO keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return (SO)this;
    }

    public int linger() {
        return this.linger;
    }

    public SO linger(int linger) {
        this.linger = linger;
        return (SO)this;
    }

    public boolean managed() {
        return this.managed;
    }

    public SO managed(boolean managed) {
        this.managed = managed;
        return (SO)this;
    }

    public Consumer<ChannelPipeline> pipelineConfigurer() {
        return this.pipelineConfigurer;
    }

    public SO pipelineConfigurer(Consumer<ChannelPipeline> pipelineConfigurer) {
        this.pipelineConfigurer = pipelineConfigurer;
        return (SO)this;
    }

    public int rcvbuf() {
        return this.rcvbuf;
    }

    public SO rcvbuf(int rcvbuf) {
        this.rcvbuf = rcvbuf;
        return (SO)this;
    }

    public SslContextBuilder ssl() {
        return this.sslOptions;
    }

    public SO ssl(SslContextBuilder sslOptions) {
        this.sslOptions = sslOptions;
        return (SO)this;
    }

    public SO sslConfigurer(Consumer<? super SslContextBuilder> sslConfigurer) {
        sslConfigurer.accept((SslContextBuilder)this.sslOptions);
        return (SO)this;
    }

    public final SO sslHandshakeTimeout(Duration sslHandshakeTimeout) {
        return this.sslHandshakeTimeoutMillis(sslHandshakeTimeout.toMillis());
    }

    public SO sslHandshakeTimeoutMillis(long sslHandshakeTimeoutMillis) {
        this.sslHandshakeTimeoutMillis = sslHandshakeTimeoutMillis;
        return (SO)this;
    }

    public long sslHandshakeTimeoutMillis() {
        return this.sslHandshakeTimeoutMillis;
    }

    public int sndbuf() {
        return this.sndbuf;
    }

    public SO sndbuf(int sndbuf) {
        this.sndbuf = sndbuf;
        return (SO)this;
    }

    public boolean tcpNoDelay() {
        return this.tcpNoDelay;
    }

    public SO tcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return (SO)this;
    }

    public long timeoutMillis() {
        return this.timeout;
    }

    public SO timeoutMillis(long timeout) {
        this.timeout = timeout;
        return (SO)this;
    }

    public final SO timeout(Duration timeout) {
        return this.timeoutMillis(timeout.toMillis());
    }
}

