/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.config;

import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.security.cert.CertificateException;
import java.util.function.Consumer;
import reactor.core.Exceptions;
import reactor.ipc.netty.config.NettyOptions;

public class ServerOptions
extends NettyOptions<ServerOptions> {
    protected InetSocketAddress listenAddress;
    private NetworkInterface multicastInterface;
    private int backlog = 1000;
    private boolean reuseAddr = true;
    private ProtocolFamily protocolFamily = null;

    public static ServerOptions create() {
        return (ServerOptions)new ServerOptions().daemon(false);
    }

    public static ServerOptions on(int port) {
        return ServerOptions.on("127.0.0.1", port);
    }

    public static ServerOptions on(String bind_address) {
        return ServerOptions.on(bind_address, 0);
    }

    public static ServerOptions on(String address, int port) {
        return (ServerOptions)new ServerOptions().listen(address, port).daemon(false);
    }

    ServerOptions() {
    }

    public int backlog() {
        return this.backlog;
    }

    public ServerOptions backlog(int backlog) {
        this.backlog = backlog;
        return this;
    }

    public ServerOptions listen(int port) {
        return this.listen(new InetSocketAddress(port));
    }

    public ServerOptions listen(String host, int port) {
        if (null == host) {
            host = "localhost";
        }
        return this.listen(new InetSocketAddress(host, port));
    }

    public ServerOptions listen(InetSocketAddress listenAddress) {
        this.listenAddress = listenAddress;
        return this;
    }

    public InetSocketAddress listenAddress() {
        return this.listenAddress;
    }

    public ServerOptions multicastInterface(NetworkInterface iface) {
        this.multicastInterface = iface;
        return this;
    }

    public NetworkInterface multicastInterface() {
        return this.multicastInterface;
    }

    public ProtocolFamily protocolFamily() {
        return this.protocolFamily;
    }

    public ServerOptions protocolFamily(ProtocolFamily protocolFamily) {
        this.protocolFamily = protocolFamily;
        return this;
    }

    public boolean reuseAddr() {
        return this.reuseAddr;
    }

    public ServerOptions reuseAddr(boolean reuseAddr) {
        this.reuseAddr = reuseAddr;
        return this;
    }

    public ServerOptions sslSelfSigned() {
        SelfSignedCertificate ssc;
        try {
            ssc = new SelfSignedCertificate();
        }
        catch (CertificateException e) {
            throw Exceptions.bubble((Throwable)e);
        }
        return (ServerOptions)this.ssl(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()));
    }

    public ServerOptions toImmutable() {
        return new ImmutableServerOptions(this);
    }

    static final class ImmutableServerOptions
    extends ServerOptions {
        final ServerOptions options;

        ImmutableServerOptions(ServerOptions options) {
            this.options = options;
            if (options.ssl() != null) {
                super.ssl(options.ssl());
            }
        }

        @Override
        public InetSocketAddress listenAddress() {
            return this.options.listenAddress();
        }

        @Override
        public int backlog() {
            return this.options.backlog();
        }

        @Override
        public NetworkInterface multicastInterface() {
            return this.options.multicastInterface();
        }

        @Override
        public ProtocolFamily protocolFamily() {
            return this.options.protocolFamily();
        }

        @Override
        public boolean reuseAddr() {
            return this.options.reuseAddr();
        }

        @Override
        public EventLoopGroup eventLoopGroup() {
            return this.options.eventLoopGroup();
        }

        @Override
        public boolean daemon() {
            return this.options.daemon();
        }

        @Override
        public ServerOptions daemon(boolean daemon) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public boolean managed() {
            return this.options.managed();
        }

        @Override
        public boolean keepAlive() {
            return this.options.keepAlive();
        }

        @Override
        public int linger() {
            return this.options.linger();
        }

        @Override
        public Consumer<ChannelPipeline> pipelineConfigurer() {
            return this.options.pipelineConfigurer();
        }

        @Override
        public int rcvbuf() {
            return this.options.rcvbuf();
        }

        @Override
        public int sndbuf() {
            return this.options.sndbuf();
        }

        @Override
        public boolean tcpNoDelay() {
            return this.options.tcpNoDelay();
        }

        @Override
        public long timeoutMillis() {
            return this.options.timeoutMillis();
        }

        @Override
        public ServerOptions backlog(int backlog) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions listen(int port) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions listen(String host, int port) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions listen(InetSocketAddress listenAddress) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions multicastInterface(NetworkInterface iface) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions protocolFamily(ProtocolFamily protocolFamily) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions reuseAddr(boolean reuseAddr) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions eventLoopGroup(EventLoopGroup eventLoopGroup) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions keepAlive(boolean keepAlive) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions linger(int linger) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions managed(boolean managed) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions pipelineConfigurer(Consumer<ChannelPipeline> pipelineConfigurer) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions rcvbuf(int rcvbuf) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions ssl(SslContextBuilder sslOptions) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions sslConfigurer(Consumer<? super SslContextBuilder> consumer) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions toImmutable() {
            return this;
        }

        @Override
        public ServerOptions sndbuf(int sndbuf) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions tcpNoDelay(boolean tcpNoDelay) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions sslHandshakeTimeoutMillis(long sslHandshakeTimeoutMillis) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ServerOptions sslSelfSigned() {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public long sslHandshakeTimeoutMillis() {
            return this.options.sslHandshakeTimeoutMillis();
        }

        @Override
        public ServerOptions timeoutMillis(long timeout) {
            throw new UnsupportedOperationException("Immutable Options");
        }
    }
}

