/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpMethod;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.Loopback;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;
import reactor.ipc.netty.common.ChannelBridge;
import reactor.ipc.netty.common.ColocatedEventLoopGroup;
import reactor.ipc.netty.common.NettyChannel;
import reactor.ipc.netty.config.ClientOptions;
import reactor.ipc.netty.http.HttpChannel;
import reactor.ipc.netty.http.HttpClientChannel;
import reactor.ipc.netty.http.HttpClientRequest;
import reactor.ipc.netty.http.HttpClientResponse;
import reactor.ipc.netty.http.HttpOutbound;
import reactor.ipc.netty.http.MonoHttpClientChannel;
import reactor.ipc.netty.http.NettyHttpChannel;
import reactor.ipc.netty.http.NettyHttpClientHandler;
import reactor.ipc.netty.tcp.TcpChannel;
import reactor.ipc.netty.tcp.TcpClient;

public class HttpClient
implements Loopback {
    static final DefaultState global = new DefaultState();
    final TcpBridgeClient client;
    static final String WS_SCHEME = "ws";
    static final String WSS_SCHEME = "wss";
    static final String HTTP_SCHEME = "http";
    static final String HTTPS_SCHEME = "https";

    public static HttpClient create() {
        return HttpClient.create(ClientOptions.create().sslSupport());
    }

    public static HttpClient create(ClientOptions options) {
        return new HttpClient(options);
    }

    public static HttpClient create(String address) {
        return HttpClient.create(address, 80);
    }

    public static HttpClient create(String address, int port) {
        return HttpClient.create(ClientOptions.create().connect(address, port));
    }

    protected HttpClient(ClientOptions options) {
        this.client = new TcpBridgeClient(options);
    }

    public Object connectedInput() {
        return this.client;
    }

    public final Mono<HttpClientResponse> delete(String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        return this.request(HttpMethod.DELETE, url, handler);
    }

    public final Mono<HttpClientResponse> delete(String url) {
        return this.request(HttpMethod.DELETE, url, null);
    }

    public final Mono<HttpClientResponse> get(String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        return this.request(HttpMethod.GET, url, handler);
    }

    public final Mono<HttpClientResponse> get(String url) {
        return this.request(HttpMethod.GET, url, null);
    }

    public final Mono<HttpClientResponse> patch(String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        return this.request(HttpMethod.PATCH, url, handler);
    }

    public final Mono<HttpClientResponse> patch(String url) {
        return this.request(HttpMethod.PATCH, url, null);
    }

    public boolean isShutdown() {
        return this.client.isShutdown();
    }

    public final Mono<HttpClientResponse> post(String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        return this.request(HttpMethod.POST, url, handler);
    }

    public final Mono<HttpClientResponse> put(String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        return this.request(HttpMethod.PUT, url, handler);
    }

    public Mono<HttpClientResponse> request(HttpMethod method, String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        URI currentURI;
        try {
            if (method == null && url == null) {
                throw new IllegalArgumentException("Method && url cannot be both null");
            }
            currentURI = new URI(this.parseURL(url, false));
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
        return new MonoHttpClientChannel(this, currentURI, method, handler);
    }

    public final Mono<HttpClientResponse> ws(String url) {
        return this.request(HttpMethod.GET, this.parseURL(url, true), HttpOutbound::upgradeToWebsocket);
    }

    public final Mono<HttpClientResponse> ws(String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        return this.request(HttpMethod.GET, this.parseURL(url, true), ch -> ch.upgradeToTextWebsocket().then(() -> MonoSource.wrap((Publisher)((Publisher)handler.apply((HttpClientRequest)ch)))));
    }

    public final Mono<Void> shutdown() {
        return this.client.shutdown();
    }

    Mono<Void> doStart(URI url, ChannelBridge<? extends TcpChannel> bridge, Function<? super HttpChannel, ? extends Publisher<Void>> handler) {
        boolean secure;
        boolean bl = secure = url.getScheme() != null && (url.getScheme().toLowerCase().equals(HTTPS_SCHEME) || url.getScheme().toLowerCase().equals(WSS_SCHEME));
        int port = url.getPort() != -1 ? url.getPort() : (secure ? 443 : 80);
        return this.client.doStart(inoutChannel -> (Publisher)handler.apply((NettyHttpChannel)inoutChannel), this.client.getOptions().proxyType() != null ? InetSocketAddress.createUnresolved(url.getHost(), port) : new InetSocketAddress(url.getHost(), port), bridge, secure);
    }

    final String parseURL(String url, boolean ws) {
        if (!url.startsWith(HTTP_SCHEME) && !url.startsWith(WS_SCHEME)) {
            String parsedUrl = (ws ? WS_SCHEME : HTTP_SCHEME) + "://";
            if (url.startsWith("/")) {
                return parsedUrl + (this.client.getOptions().proxyType() == null && this.client.getConnectAddress() != null ? this.client.getConnectAddress().getHostName() + ":" + this.client.getConnectAddress().getPort() : "localhost") + url;
            }
            return parsedUrl + url;
        }
        return url;
    }

    static final class DefaultState {
        volatile ColocatedEventLoopGroup clientGroup;
        static final AtomicReferenceFieldUpdater<DefaultState, ColocatedEventLoopGroup> CLIENT_GROUP = AtomicReferenceFieldUpdater.newUpdater(DefaultState.class, ColocatedEventLoopGroup.class, "clientGroup");

        DefaultState() {
        }
    }

    final class TcpBridgeClient
    extends TcpClient {
        TcpBridgeClient(ClientOptions options) {
            super(options);
        }

        @Override
        protected void bindChannel(Function<? super NettyChannel, ? extends Publisher<Void>> handler, SocketChannel ch, ChannelBridge<? extends TcpChannel> channelBridge) {
            ch.pipeline().addLast("httpCodecHandler", (ChannelHandler)new HttpClientCodec()).addLast("reactiveBridge", (ChannelHandler)new NettyHttpClientHandler(handler, (ChannelBridge<HttpClientChannel>)channelBridge, (Channel)ch));
        }

        @Override
        protected Mono<Void> doStart(Function<? super NettyChannel, ? extends Publisher<Void>> handler, InetSocketAddress address, ChannelBridge<? extends TcpChannel> channelBridge, boolean secure) {
            return super.doStart(handler, address, channelBridge, secure);
        }

        @Override
        protected Class<?> logClass() {
            return HttpClient.class;
        }

        @Override
        protected ClientOptions getOptions() {
            return super.getOptions();
        }
    }
}

