/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.util.concurrent.Future;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Subscriber;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.common.MonoChannelFuture;
import reactor.ipc.netty.http.Cookies;
import reactor.ipc.netty.http.HttpClientRequest;
import reactor.ipc.netty.http.HttpClientResponse;
import reactor.ipc.netty.http.NettyHttpChannel;
import reactor.ipc.netty.http.NettyHttpClientHandler;
import reactor.ipc.netty.http.NettyWebSocketClientHandler;

final class HttpClientChannel
extends NettyHttpChannel
implements HttpClientResponse,
HttpClientRequest {
    final String[] redirectedFrom;
    final boolean isSecure;
    boolean redirectable;
    Cookies cookies;
    static final int MAX_REDIRECTS = 50;
    static final String[] EMPTY_REDIRECTIONS = new String[0];

    public HttpClientChannel(Channel ioChannel, Flux<Object> input, boolean isSecure, String[] redirects) {
        super(ioChannel, input, null);
        this.isSecure = isSecure;
        this.redirectedFrom = redirects == null ? EMPTY_REDIRECTIONS : redirects;
    }

    @Override
    void setNettyResponse(HttpResponse nettyResponse) {
        super.setNettyResponse(nettyResponse);
        this.cookies = Cookies.newClientResponseHolder(this.responseHeaders());
    }

    @Override
    public boolean isWebsocket() {
        return this.delegate().pipeline().get(NettyWebSocketClientHandler.class) != null;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public HttpClientRequest flushEach() {
        super.flushEach();
        return this;
    }

    @Override
    protected void doSubscribeHeaders(Subscriber<? super Void> s) {
        MonoChannelFuture.from((Future)this.delegate().writeAndFlush((Object)this.getNettyRequest())).subscribe(s);
    }

    @Override
    public Mono<Void> upgradeToWebsocket(String protocols, boolean textPlain) {
        URI uri;
        ChannelPipeline pipeline = this.delegate().pipeline();
        try {
            String url = this.uri();
            if (url.startsWith("http") || url.startsWith("ws")) {
                uri = new URI(url);
            } else {
                String host = this.headers().get((CharSequence)HttpHeaderNames.HOST);
                uri = new URI((this.isSecure ? "wss" : "ws") + "://" + host + (url.startsWith("/") ? url : "/" + url));
            }
            this.headers().remove((CharSequence)HttpHeaderNames.HOST);
        }
        catch (URISyntaxException e) {
            throw Exceptions.bubble((Throwable)e);
        }
        pipeline.addLast("reactorHttpAggregator", (ChannelHandler)new HttpObjectAggregator(8192));
        NettyWebSocketClientHandler handler = ((NettyHttpClientHandler)pipeline.remove(NettyHttpClientHandler.class)).withWebsocketSupport(uri, protocols, textPlain);
        if (handler != null) {
            pipeline.addLast("reactiveBridge", (ChannelHandler)handler);
            return MonoChannelFuture.from((Future)handler.handshakerResult);
        }
        return Mono.error((Throwable)new IllegalStateException("Failed to upgrade to websocket"));
    }

    @Override
    public Map<CharSequence, Set<Cookie>> cookies() {
        return this.cookies.getCachedCookies();
    }

    @Override
    public HttpClientRequest followRedirect() {
        this.redirectable = true;
        return this;
    }

    @Override
    public boolean isFollowRedirect() {
        return this.redirectable && this.redirectedFrom.length <= 50;
    }

    @Override
    public String[] redirectedFrom() {
        return Arrays.asList(this.redirectedFrom).toArray(new String[this.redirectedFrom.length]);
    }
}

