/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.InetSocketAddress;
import reactor.core.publisher.Flux;
import reactor.ipc.netty.common.ByteBufEncodedFlux;
import reactor.ipc.netty.common.NettyChannel;
import reactor.ipc.netty.common.NettyInbound;
import reactor.ipc.netty.http.HttpConnection;
import reactor.ipc.netty.http.MultipartInbound;
import reactor.ipc.netty.http.multipart.MultipartCodec;

public interface HttpInbound
extends HttpConnection,
NettyInbound {
    public HttpHeaders responseHeaders();

    public HttpResponseStatus status();

    default public MultipartInbound receiveMultipart() {
        final HttpInbound thiz = this;
        return new MultipartInbound(){

            @Override
            public Channel delegate() {
                return thiz.delegate();
            }

            @Override
            public Flux<ByteBufEncodedFlux> receiveParts() {
                return MultipartCodec.decode(thiz);
            }

            @Override
            public NettyChannel.Lifecycle on() {
                return thiz.on();
            }

            @Override
            public InetSocketAddress remoteAddress() {
                return thiz.remoteAddress();
            }
        };
    }
}

