/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.ipc.netty.http.HttpChannel;
import reactor.ipc.netty.http.RegistryHttpMappings;

public abstract class HttpMappings
implements Function<HttpChannel, Iterable<? extends Function<? super HttpChannel, ? extends Publisher<Void>>>> {
    static final boolean hasBus;
    private static final boolean FORCE_SIMPLE_MAPPINGS;

    public static Predicate<HttpChannel> delete(String uri) {
        return HttpMappings.http(uri, null, HttpMethod.DELETE);
    }

    public static Predicate<HttpChannel> get(String uri) {
        return HttpMappings.http(uri, null, HttpMethod.GET);
    }

    public static Predicate<HttpChannel> http(String uri, HttpVersion protocol, HttpMethod method) {
        if (null == uri) {
            return null;
        }
        if (hasBus && !FORCE_SIMPLE_MAPPINGS) {
            return new RegistryHttpMappings.HttpSelector(uri, protocol, method);
        }
        return new HttpPredicate(uri, protocol, method);
    }

    public static HttpMappings newMappings() {
        if (hasBus && !FORCE_SIMPLE_MAPPINGS) {
            return new RegistryHttpMappings();
        }
        return new SimpleHttpMappings();
    }

    public static Predicate<HttpChannel> post(String uri) {
        return HttpMappings.http(uri, null, HttpMethod.POST);
    }

    public static Predicate<HttpChannel> prefix(String prefix) {
        return HttpMappings.prefix(prefix, HttpMethod.GET);
    }

    public static Predicate<HttpChannel> prefix(String prefix, HttpMethod method) {
        String target;
        Objects.requireNonNull(prefix, "Prefix must be provided");
        String string = target = prefix.startsWith("/") ? prefix : "/".concat(prefix);
        if (hasBus && !FORCE_SIMPLE_MAPPINGS) {
            return new RegistryHttpMappings.HttpSelector(target + "**", null, method);
        }
        return new HttpPrefixPredicate(target, method);
    }

    public static Predicate<HttpChannel> put(String uri) {
        return HttpMappings.http(uri, null, HttpMethod.PUT);
    }

    public abstract HttpMappings add(Predicate<? super HttpChannel> var1, Function<? super HttpChannel, ? extends Publisher<Void>> var2);

    static {
        boolean bus;
        try {
            RegistryHttpMappings.class.getClassLoader().loadClass("reactor.bus.registry.Registry");
            bus = true;
        }
        catch (ClassNotFoundException cfe) {
            bus = false;
        }
        hasBus = bus;
        FORCE_SIMPLE_MAPPINGS = Boolean.parseBoolean(System.getProperty("reactor.net.forceSimpleMappings", "false"));
    }

    static final class HttpPrefixPredicate
    implements Predicate<HttpChannel> {
        protected final HttpMethod method;
        protected final String prefix;

        public HttpPrefixPredicate(String prefix, HttpMethod method) {
            this.prefix = prefix;
            this.method = method;
        }

        @Override
        public boolean test(HttpChannel key) {
            return (this.method == null || this.method.equals((Object)key.method())) && key.uri().startsWith(this.prefix);
        }
    }

    public static class HttpPredicate
    implements Predicate<HttpChannel> {
        protected final HttpVersion protocol;
        protected final HttpMethod method;
        protected final String uri;

        public HttpPredicate(String uri) {
            this(uri, null, null);
        }

        public HttpPredicate(String uri, HttpVersion protocol, HttpMethod method) {
            this.protocol = protocol;
            this.uri = uri;
            this.method = method;
        }

        @Override
        public final boolean test(HttpChannel key) {
            return !(this.protocol != null && !this.protocol.equals((Object)key.version()) || this.method != null && !this.method.equals((Object)key.method()) || this.uri != null && !this.uri.equals(key.uri()));
        }
    }

    static final class SimpleHttpMappings
    extends HttpMappings {
        private final CopyOnWriteArrayList<HttpHandlerMapping> handlers = new CopyOnWriteArrayList();

        SimpleHttpMappings() {
        }

        @Override
        public HttpMappings add(Predicate<? super HttpChannel> condition, Function<? super HttpChannel, ? extends Publisher<Void>> handler) {
            this.handlers.add(new HttpHandlerMapping(condition, handler, null));
            return this;
        }

        @Override
        public Iterable<? extends Function<? super HttpChannel, ? extends Publisher<Void>>> apply(final HttpChannel channel) {
            return () -> {
                final Iterator<HttpHandlerMapping> iterator = this.handlers.iterator();
                return new Iterator<Function<? super HttpChannel, ? extends Publisher<Void>>>(){
                    HttpHandlerMapping cached;

                    @Override
                    public boolean hasNext() {
                        while (iterator.hasNext()) {
                            HttpHandlerMapping cursor = (HttpHandlerMapping)iterator.next();
                            if (!cursor.test(channel)) continue;
                            this.cached = cursor;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public Function<? super HttpChannel, ? extends Publisher<Void>> next() {
                        HttpHandlerMapping cursor = this.cached;
                        if (cursor != null) {
                            this.cached = null;
                            return cursor;
                        }
                        this.hasNext();
                        return this.cached;
                    }
                };
            };
        }
    }

    static final class HttpHandlerMapping
    implements Function<HttpChannel, Publisher<Void>>,
    Predicate<HttpChannel> {
        private final Predicate<? super HttpChannel> condition;
        private final Function<? super HttpChannel, ? extends Publisher<Void>> handler;
        private final Function<? super String, Map<String, Object>> resolver;

        HttpHandlerMapping(Predicate<? super HttpChannel> condition, Function<? super HttpChannel, ? extends Publisher<Void>> handler, Function<? super String, Map<String, Object>> resolver) {
            this.condition = condition;
            this.handler = handler;
            this.resolver = resolver;
        }

        @Override
        public Publisher<Void> apply(HttpChannel channel) {
            return this.handler.apply(channel.paramsResolver(this.resolver));
        }

        Function<? super HttpChannel, ? extends Publisher<Void>> getHandler() {
            return this.handler;
        }

        @Override
        public boolean test(HttpChannel o) {
            return this.condition.test(o);
        }
    }
}

