/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.Loopback;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.common.ChannelBridge;
import reactor.ipc.netty.common.DuplexSocket;
import reactor.ipc.netty.common.NettyChannel;
import reactor.ipc.netty.config.ServerOptions;
import reactor.ipc.netty.http.HttpChannel;
import reactor.ipc.netty.http.HttpMappings;
import reactor.ipc.netty.http.HttpServerChannel;
import reactor.ipc.netty.http.NettyHttpChannel;
import reactor.ipc.netty.http.NettyHttpServerHandler;
import reactor.ipc.netty.tcp.TcpServer;
import reactor.util.Logger;
import reactor.util.Loggers;

public class HttpServer
extends DuplexSocket<ByteBuf, ByteBuf, HttpChannel>
implements Loopback,
ChannelBridge<NettyHttpChannel> {
    TcpServer server;
    HttpMappings httpMappings;
    static final Logger log = Loggers.getLogger(HttpServer.class);

    public static HttpServer create() {
        return HttpServer.create("127.0.0.1");
    }

    public static HttpServer create(ServerOptions options) {
        return new HttpServer(options);
    }

    public static HttpServer create(int port) {
        return HttpServer.create("127.0.0.1", port);
    }

    public static HttpServer create(String bindAddress) {
        return HttpServer.create(bindAddress, DEFAULT_PORT);
    }

    public static HttpServer create(String bindAddress, int port) {
        return HttpServer.create(ServerOptions.create().listen(bindAddress, port));
    }

    HttpServer(ServerOptions options) {
        this.server = new TcpBridgeServer(options);
    }

    public Object connectedInput() {
        return this.server;
    }

    public TcpServer connectedOutput() {
        return this.server;
    }

    public final HttpServer delete(String path, Function<? super HttpChannel, ? extends Publisher<Void>> handler) {
        this.route(HttpMappings.delete(path), handler);
        return this;
    }

    public final HttpServer directory(String path, File directory) {
        this.directory(path, directory.getAbsolutePath());
        return this;
    }

    public final HttpServer directory(String path, String directory) {
        return this.directory(path, directory, null);
    }

    public final HttpServer directory(String path, String directory, Function<HttpChannel, HttpChannel> interceptor) {
        this.route(HttpMappings.prefix(path), channel -> {
            Path p;
            String strippedPrefix = channel.uri().replaceFirst(path, "");
            int paramIndex = strippedPrefix.lastIndexOf("?");
            if (paramIndex != -1) {
                strippedPrefix = strippedPrefix.substring(0, paramIndex);
            }
            if (Files.isReadable(p = Paths.get(directory + strippedPrefix, new String[0]))) {
                if (interceptor != null) {
                    return ((HttpChannel)interceptor.apply((HttpChannel)channel)).sendFile(p.toFile());
                }
                return channel.sendFile(p.toFile());
            }
            return Mono.error((Throwable)Exceptions.failWithCancel());
        });
        return this;
    }

    public final HttpServer file(String path, File file) {
        this.file(HttpMappings.get(path), file.getAbsolutePath(), null);
        return this;
    }

    public final HttpServer file(String path, String filepath) {
        this.file(HttpMappings.get(path), filepath, null);
        return this;
    }

    public final HttpServer file(Predicate<HttpChannel> path, String filepath, Function<HttpChannel, HttpChannel> interceptor) {
        File file = new File(filepath);
        this.route(path, channel -> {
            if (interceptor != null) {
                return ((HttpChannel)interceptor.apply((HttpChannel)channel)).sendFile(file);
            }
            return channel.sendFile(file);
        });
        return this;
    }

    public final HttpServer get(String path, Function<? super HttpChannel, ? extends Publisher<Void>> handler) {
        this.route(HttpMappings.get(path), handler);
        return this;
    }

    public InetSocketAddress getListenAddress() {
        return this.connectedOutput().getListenAddress();
    }

    @Override
    public boolean isShutdown() {
        return this.server.isShutdown();
    }

    public final HttpServer post(String path, Function<? super HttpChannel, ? extends Publisher<Void>> handler) {
        this.route(HttpMappings.post(path), handler);
        return this;
    }

    public final HttpServer put(String path, Function<? super HttpChannel, ? extends Publisher<Void>> handler) {
        this.route(HttpMappings.put(path), handler);
        return this;
    }

    public HttpServer route(Predicate<HttpChannel> condition, Function<? super HttpChannel, ? extends Publisher<Void>> serviceFunction) {
        if (this.httpMappings == null) {
            this.httpMappings = HttpMappings.newMappings();
        }
        this.httpMappings.add(condition, serviceFunction);
        return this;
    }

    public final Mono<Void> start() {
        return this.start(null);
    }

    public final void startAndAwait() throws TimeoutException {
        this.start().block();
    }

    public final HttpServer ws(String path, Function<? super HttpChannel, ? extends Publisher<Void>> handler) {
        return this.ws(path, handler, null);
    }

    public final HttpServer ws(String path, Function<? super HttpChannel, ? extends Publisher<Void>> handler, String protocols) {
        return this.route(HttpMappings.get(path), channel -> {
            String connection = channel.headers().get((CharSequence)HttpHeaderNames.CONNECTION);
            if (connection != null && connection.equals(HttpHeaderValues.UPGRADE.toString())) {
                this.onWebsocket((HttpChannel)channel, protocols);
            }
            return (Publisher)handler.apply((HttpChannel)channel);
        });
    }

    @Override
    protected Mono<Void> doStart(Function<? super HttpChannel, ? extends Publisher<Void>> defaultHandler) {
        return this.server.start(ch -> {
            NettyHttpChannel request = (NettyHttpChannel)ch;
            try {
                Publisher<Void> afterHandlers = this.routeChannel(request);
                if (afterHandlers == null) {
                    if (defaultHandler != null) {
                        return (Publisher)defaultHandler.apply(request);
                    }
                    if (request.markHeadersAsFlushed()) {
                        request.delegate().writeAndFlush((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND));
                    }
                    return Flux.empty();
                }
                return afterHandlers;
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal((Throwable)t);
                return Mono.error((Throwable)t);
            }
        });
    }

    protected final void onWebsocket(HttpChannel next, String protocols) {
        ChannelPipeline pipeline = next.delegate().pipeline();
        pipeline.addLast(new ChannelHandler[]{((NettyHttpServerHandler)pipeline.remove(NettyHttpServerHandler.class)).withWebsocketSupport(next.uri(), protocols, false)});
    }

    protected Publisher<Void> routeChannel(HttpChannel ch) {
        if (this.httpMappings == null) {
            return null;
        }
        Iterator selected = ((Iterable)this.httpMappings.apply(ch)).iterator();
        if (!selected.hasNext()) {
            return null;
        }
        Function channelHandler = (Function)selected.next();
        if (!selected.hasNext()) {
            return (Publisher)channelHandler.apply(ch);
        }
        ArrayList multiplexing = new ArrayList(4);
        multiplexing.add(channelHandler.apply(ch));
        do {
            channelHandler = (Function)selected.next();
            multiplexing.add(channelHandler.apply(ch));
        } while (selected.hasNext());
        return Flux.concat((Publisher)Flux.fromIterable(multiplexing));
    }

    @Override
    protected final Mono<Void> doShutdown() {
        return this.server.shutdown();
    }

    final void bindHttpChannel(Function<? super NettyChannel, ? extends Publisher<Void>> handler, SocketChannel nativeChannel) {
        nativeChannel.pipeline().addLast("httpCodecHandler", (ChannelHandler)new HttpServerCodec()).addLast("reactiveBridge", (ChannelHandler)new NettyHttpServerHandler(handler, this, (Channel)nativeChannel));
    }

    @Override
    public NettyHttpChannel createChannelBridge(Channel ioChannel, Flux<Object> input, Object ... parameters) {
        return new HttpServerChannel(ioChannel, input, parameters.length > 0 ? (HttpRequest)parameters[0] : null);
    }

    final class TcpBridgeServer
    extends TcpServer {
        TcpBridgeServer(ServerOptions options) {
            super(options);
        }

        @Override
        protected void bindChannel(Function<? super NettyChannel, ? extends Publisher<Void>> handler, SocketChannel nativeChannel) {
            ChannelPipeline pipeline = nativeChannel.pipeline();
            if (this.getSslContext() != null) {
                SslHandler sslHandler = this.getSslContext().newHandler(nativeChannel.alloc());
                sslHandler.setHandshakeTimeoutMillis(this.getOptions().sslHandshakeTimeoutMillis());
                pipeline.addFirst("sslHandler", (ChannelHandler)sslHandler);
            }
            if (log.isDebugEnabled()) {
                pipeline.addLast("loggingHandler", (ChannelHandler)new LoggingHandler(HttpServer.class));
            }
            if (null != this.getOptions() && null != this.getOptions().pipelineConfigurer()) {
                this.getOptions().pipelineConfigurer().accept(pipeline);
            }
            HttpServer.this.bindHttpChannel(handler, nativeChannel);
        }
    }
}

