/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.util.concurrent.Future;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.common.MonoChannelFuture;
import reactor.ipc.netty.http.Cookies;
import reactor.ipc.netty.http.NettyHttpChannel;
import reactor.ipc.netty.http.NettyHttpServerHandler;
import reactor.ipc.netty.http.NettyWebSocketServerHandler;

final class HttpServerChannel
extends NettyHttpChannel {
    private final Cookies cookies = Cookies.newServerRequestHolder(this.headers());

    HttpServerChannel(Channel ioChannel, Flux<Object> input, HttpRequest msg) {
        super(ioChannel, input, msg);
    }

    @Override
    protected void doSubscribeHeaders(Subscriber<? super Void> s) {
        MonoChannelFuture.from((Future)this.delegate().writeAndFlush((Object)this.getNettyResponse())).subscribe(s);
    }

    @Override
    public Mono<Void> upgradeToWebsocket(String protocols, boolean textPlain) {
        ChannelPipeline pipeline = this.delegate().pipeline();
        NettyWebSocketServerHandler handler = ((NettyHttpServerHandler)pipeline.remove(NettyHttpServerHandler.class)).withWebsocketSupport(this.uri(), protocols, textPlain);
        if (handler != null) {
            pipeline.addLast("reactiveBridge", (ChannelHandler)handler);
            return MonoChannelFuture.from((Future)handler.handshakerResult);
        }
        return Mono.error((Throwable)new IllegalStateException("Failed to upgrade to websocket"));
    }

    @Override
    public Map<CharSequence, Set<Cookie>> cookies() {
        return this.cookies.getCachedCookies();
    }
}

