/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import java.net.URI;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;
import reactor.ipc.netty.http.HttpClient;
import reactor.ipc.netty.http.HttpClientChannel;
import reactor.ipc.netty.http.HttpClientRequest;
import reactor.ipc.netty.http.HttpClientResponse;
import reactor.ipc.netty.http.NettyHttpClientHandler;
import reactor.ipc.netty.http.ReconnectableBridge;

final class MonoHttpClientChannel
extends Mono<HttpClientResponse> {
    final HttpClient client;
    final URI currentURI;
    final HttpMethod method;
    final Function<? super HttpClientRequest, ? extends Publisher<Void>> handler;
    static final AsciiString ALL = new AsciiString((CharSequence)"*/*");

    MonoHttpClientChannel(HttpClient client, URI currentURI, HttpMethod method, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        this.client = client;
        this.currentURI = currentURI;
        this.method = method;
        this.handler = handler;
    }

    public void subscribe(Subscriber<? super HttpClientResponse> subscriber) {
        ReconnectableBridge bridge = new ReconnectableBridge(this.currentURI.getScheme().equalsIgnoreCase("https") || this.currentURI.getScheme().equalsIgnoreCase("wss"));
        bridge.activeURI = this.currentURI;
        Mono.defer(() -> {
            DirectProcessor connectSignal = DirectProcessor.create();
            return (Mono)this.client.doStart(bridge.activeURI, bridge, c -> {
                try {
                    URI uri = bridge.activeURI;
                    HttpClientChannel ch = (HttpClientChannel)c;
                    ch.getNettyRequest().setUri(uri.getPath() + (uri.getQuery() == null ? "" : "?" + uri.getRawQuery())).setMethod(this.method).setProtocolVersion(HttpVersion.HTTP_1_1).headers().add((CharSequence)HttpHeaderNames.HOST, (Object)uri.getHost()).add((CharSequence)HttpHeaderNames.ACCEPT, (Object)ALL);
                    if (this.method == HttpMethod.GET || this.method == HttpMethod.HEAD) {
                        ch.removeTransferEncodingChunked();
                    }
                    if (ch.delegate().eventLoop().inEventLoop()) {
                        ((NettyHttpClientHandler)ch.delegate().pipeline().get(NettyHttpClientHandler.class)).bridgeReply(subscriber, (DirectProcessor<Void>)connectSignal);
                    } else {
                        ch.delegate().eventLoop().execute(() -> ((NettyHttpClientHandler)ch.delegate().pipeline().get(NettyHttpClientHandler.class)).bridgeReply(subscriber, (DirectProcessor<Void>)connectSignal));
                    }
                    if (this.handler != null) {
                        return this.handler.apply(ch);
                    }
                    HttpUtil.setTransferEncodingChunked((HttpMessage)ch.getNettyResponse(), (boolean)false);
                    return ch.sendHeaders();
                }
                catch (Throwable t) {
                    return Mono.error((Throwable)t);
                }
            }).concatWith((Publisher)connectSignal).as(MonoSource::wrap);
        }).retry((Predicate)bridge).subscribe(null, reason -> Operators.error((Subscriber)subscriber, (Throwable)reason));
    }
}

