/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import reactor.core.publisher.Flux;
import reactor.ipc.netty.http.NettyHttpClientHandler;

final class NettyWebSocketClientHandler
extends NettyHttpClientHandler {
    final WebSocketClientHandshaker handshaker;
    final ChannelPromise handshakerResult;
    final boolean plainText;

    NettyWebSocketClientHandler(URI currentURI, String protocols, NettyHttpClientHandler originalHandler, boolean plainText) {
        super(originalHandler.getHandler(), null, originalHandler.httpChannel.delegate(), originalHandler);
        this.plainText = plainText;
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)currentURI, (WebSocketVersion)WebSocketVersion.V13, (String)protocols, (boolean)true, (HttpHeaders)this.httpChannel.headers());
        this.handshakerResult = this.httpChannel.delegate().newPromise();
        if (!originalHandler.httpChannel.delegate().pipeline().context(HttpClientCodec.class).name().equals("httpCodecHandler")) {
            originalHandler.httpChannel.delegate().pipeline().remove(HttpClientCodec.class);
        }
        this.handshaker.handshake(this.httpChannel.delegate()).addListener(f -> {
            if (!f.isSuccess()) {
                this.handshakerResult.tryFailure(f.cause());
                return;
            }
            this.httpChannel.delegate().read();
        });
    }

    @Override
    protected void postRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof CloseWebSocketFrame) {
            if (log.isDebugEnabled()) {
                log.debug("Closing Websocket");
            }
            ctx.channel().close();
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Class<?> messageClass = msg.getClass();
        if (FullHttpResponse.class.isAssignableFrom(messageClass)) {
            ctx.pipeline().remove(HttpObjectAggregator.class);
            HttpResponse response = (HttpResponse)msg;
            if (this.httpChannel != null) {
                this.httpChannel.setNettyResponse(response);
            }
            if (this.checkResponseCode(ctx, response)) {
                if (!this.handshaker.isHandshakeComplete()) {
                    this.handshaker.finishHandshake(ctx.channel(), (FullHttpResponse)msg);
                }
                ctx.fireChannelRead(msg);
                this.handshakerResult.trySuccess();
                if (this.replySubscriber != null) {
                    Flux.just((Object)this.httpChannel).subscribe(this.replySubscriber);
                }
            }
            return;
        }
        if (PingWebSocketFrame.class.isAssignableFrom(messageClass)) {
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(((PingWebSocketFrame)msg).content().retain()));
            return;
        }
        if (TextWebSocketFrame.class.isAssignableFrom(messageClass)) {
            this.downstream().next(msg);
        } else if (CloseWebSocketFrame.class.isAssignableFrom(messageClass)) {
            if (log.isDebugEnabled()) {
                log.debug("Closing Websocket");
            }
            ctx.close();
        } else {
            this.doRead(msg);
        }
    }

    @Override
    protected ChannelFuture doOnWrite(Object data, ChannelHandlerContext ctx) {
        if (data instanceof ByteBuf) {
            if (this.plainText) {
                return ctx.write((Object)new TextWebSocketFrame((ByteBuf)data));
            }
            return ctx.write((Object)new BinaryWebSocketFrame((ByteBuf)data));
        }
        if (data instanceof String) {
            return ctx.write((Object)new TextWebSocketFrame((String)data));
        }
        return ctx.write(data);
    }
}

