/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import reactor.ipc.netty.http.NettyHttpServerHandler;

final class NettyWebSocketServerHandler
extends NettyHttpServerHandler {
    final WebSocketServerHandshaker handshaker;
    final ChannelFuture handshakerResult;
    final boolean plainText;

    public NettyWebSocketServerHandler(String wsUrl, String protocols, NettyHttpServerHandler originalHandler, boolean plainText) {
        super(originalHandler.getHandler(), null, originalHandler.request.delegate(), originalHandler);
        this.plainText = plainText;
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(wsUrl, protocols, true);
        this.handshaker = wsFactory.newHandshaker(this.request.getNettyRequest());
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)this.request.delegate());
            this.handshakerResult = null;
        } else {
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.request.getNettyResponse(), (boolean)false);
            this.handshakerResult = this.handshaker.handshake(this.request.delegate(), this.request.getNettyRequest(), this.request.responseHeaders(), this.request.delegate().newPromise()).addListener((GenericFutureListener)((ChannelFutureListener)future -> this.request.delegate().read()));
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object frame) throws Exception {
        if (CloseWebSocketFrame.class.equals(frame.getClass())) {
            this.handshaker.close(ctx.channel(), ((CloseWebSocketFrame)frame).retain());
            this.downstream().complete();
            return;
        }
        if (PingWebSocketFrame.class.isAssignableFrom(frame.getClass())) {
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(((PingWebSocketFrame)frame).content().retain()));
            return;
        }
        this.doRead(frame);
    }

    @Override
    protected ChannelFuture doOnWrite(Object data, ChannelHandlerContext ctx) {
        if (data instanceof ByteBuf) {
            if (this.plainText) {
                return ctx.write((Object)new TextWebSocketFrame((ByteBuf)data));
            }
            return ctx.write((Object)new BinaryWebSocketFrame((ByteBuf)data));
        }
        if (data instanceof String) {
            return ctx.write((Object)new TextWebSocketFrame((String)data));
        }
        return ctx.write(data);
    }
}

