/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http;

import io.netty.channel.Channel;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Predicate;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.ipc.netty.common.ChannelBridge;
import reactor.ipc.netty.http.HttpClientChannel;
import reactor.ipc.netty.http.RedirectException;

final class ReconnectableBridge
implements ChannelBridge<HttpClientChannel>,
Predicate<Throwable> {
    final boolean isSecure;
    URI activeURI;
    String[] redirectedFrom;

    public ReconnectableBridge(boolean isSecure) {
        this.isSecure = isSecure;
    }

    @Override
    public HttpClientChannel createChannelBridge(Channel ioChannel, Flux<Object> input, Object ... parameters) {
        return new HttpClientChannel(ioChannel, input, this.isSecure, this.redirectedFrom);
    }

    void redirect(String to) {
        URI from = this.activeURI;
        try {
            this.activeURI = new URI(to);
        }
        catch (URISyntaxException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        if (this.redirectedFrom == null) {
            this.redirectedFrom = new String[]{from.toString()};
        } else {
            String[] newRedirectedFrom = new String[this.redirectedFrom.length + 1];
            System.arraycopy(this.redirectedFrom, 0, newRedirectedFrom, 0, this.redirectedFrom.length);
            newRedirectedFrom[this.redirectedFrom.length] = from.toString();
            this.redirectedFrom = newRedirectedFrom;
        }
    }

    @Override
    public boolean test(Throwable throwable) {
        if (throwable instanceof RedirectException) {
            RedirectException re = (RedirectException)throwable;
            this.redirect(re.location);
            return true;
        }
        return false;
    }
}

