/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.bus.registry.Registries;
import reactor.bus.registry.Registry;
import reactor.bus.selector.Selector;
import reactor.bus.selector.Selectors;
import reactor.bus.selector.UriPathSelector;
import reactor.ipc.netty.http.HttpChannel;
import reactor.ipc.netty.http.HttpMappings;

final class RegistryHttpMappings
extends HttpMappings {
    private final Registry<HttpChannel, HttpMappings.HttpHandlerMapping> routedWriters = Registries.create();

    RegistryHttpMappings() {
    }

    @Override
    public Iterable<? extends Function<? super HttpChannel, ? extends Publisher<Void>>> apply(HttpChannel channel) {
        return this.routedWriters.selectValues((Object)channel);
    }

    @Override
    public HttpMappings add(Predicate<? super HttpChannel> condition, Function<? super HttpChannel, ? extends Publisher<Void>> handler) {
        Selector selector = Selector.class.isAssignableFrom(condition.getClass()) ? (Selector)condition : Selectors.predicate(condition);
        this.routedWriters.register(selector, (Object)new HttpMappings.HttpHandlerMapping(condition, handler, selector.getHeaderResolver()));
        return this;
    }

    static {
        try {
            RegistryHttpMappings.class.getClassLoader().loadClass("reactor.bus.registry.Registry");
        }
        catch (ClassNotFoundException cfe) {
            throw new IllegalStateException("io.projectreactor.addons:reactor-bus dependency is missing from the classpath.");
        }
    }

    public static final class HttpSelector
    extends HttpMappings.HttpPredicate
    implements Selector<HttpChannel> {
        final UriPathSelector uriPathSelector;

        public HttpSelector(String uri, HttpVersion protocol, HttpMethod method) {
            super(null, protocol, method);
            this.uriPathSelector = uri != null && !uri.isEmpty() ? new UriPathSelector(uri) : null;
        }

        public Object getObject() {
            return this.uriPathSelector != null ? this.uriPathSelector.getObject() : null;
        }

        public Function<Object, Map<String, Object>> getHeaderResolver() {
            return this.uriPathSelector != null ? this.uriPathSelector.getHeaderResolver() : null;
        }

        public boolean matches(HttpChannel key) {
            return this.test(key) && (this.uriPathSelector == null || this.uriPathSelector.matches((Object)key.uri()));
        }
    }
}

