/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.ipc.netty.common.ByteBufEncodedFlux;
import reactor.ipc.netty.http.HttpInbound;
import reactor.ipc.netty.http.multipart.MultipartDecoder;

public final class MultipartCodec {
    static final Pattern MULTIPART_PATTERN = Pattern.compile("multipart.*; boundary=(.+)");

    public static Flux<ByteBufEncodedFlux> decode(HttpInbound inbound) {
        String boundary = MultipartCodec.extractBoundary(inbound.responseHeaders());
        return new MultipartDecoder((Publisher<ByteBuf>)inbound.receive(), boundary, inbound.delegate().alloc());
    }

    static String extractBoundary(HttpHeaders headers) {
        return headers.entries().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("Content-Type")).map(entry -> MULTIPART_PATTERN.matcher((CharSequence)entry.getValue())).filter(Matcher::find).map(matcher -> matcher.group(1)).findFirst().orElseThrow(() -> new IllegalStateException("Not a valid multipart response"));
    }
}

