/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.tcp;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import reactor.core.publisher.DirectProcessor;

final class NettySslReader
extends ChannelDuplexHandler {
    final DirectProcessor<Void> secureCallback;
    boolean handshakeDone;

    NettySslReader(DirectProcessor<Void> secureCallback) {
        this.secureCallback = secureCallback;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (!this.handshakeDone) {
            ctx.read();
        }
        super.channelReadComplete(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            this.handshakeDone = true;
            SslHandshakeCompletionEvent handshake = (SslHandshakeCompletionEvent)evt;
            if (this.secureCallback != null) {
                if (handshake.isSuccess()) {
                    ctx.fireChannelActive();
                    this.secureCallback.onComplete();
                } else {
                    this.secureCallback.onError(handshake.cause());
                }
            } else if (!handshake.isSuccess()) {
                ctx.fireExceptionCaught(handshake.cause());
            } else {
                ctx.fireChannelActive();
            }
        }
        super.userEventTriggered(ctx, evt);
    }
}

