/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.util;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.ThreadFactory;
import reactor.ipc.netty.common.ColocatedEventLoopGroup;

public class EpollDetector {
    private static final boolean epoll;

    public static EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory) {
        return epoll ? new EpollEventLoopGroup(threads, factory) : new NioEventLoopGroup(threads, factory);
    }

    public static Class<? extends ServerChannel> getServerChannel(EventLoopGroup group) {
        return EpollDetector.useEpoll(group) ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    public static Class<? extends Channel> getChannel(EventLoopGroup group) {
        return EpollDetector.useEpoll(group) ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    public static Class<? extends Channel> getDatagramChannel(EventLoopGroup group) {
        return EpollDetector.useEpoll(group) ? EpollDatagramChannel.class : NioDatagramChannel.class;
    }

    public static boolean hasEpoll() {
        return epoll;
    }

    private static boolean useEpoll(EventLoopGroup group) {
        if (!epoll) {
            return false;
        }
        if (group instanceof ColocatedEventLoopGroup) {
            group = ((ColocatedEventLoopGroup)group).getEventLoopGroup();
        }
        return group instanceof EpollEventLoopGroup;
    }

    static {
        boolean epollCheck = false;
        try {
            Class.forName("io.netty.channel.epoll.Epoll");
            epollCheck = Epoll.isAvailable();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        epoll = epollCheck;
    }
}

