/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.util;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ThreadFactory;
import reactor.ipc.netty.util.EpollDetector;
import reactor.util.Loggers;

public final class NettyNativeDetector {
    static final NettyNativeDetector DEFAULT = Boolean.parseBoolean(System.getProperty("reactor.ipc.epoll", "true")) ? (!PlatformDependent.isWindows() ? new NettyNativeDetector(EpollDetector.hasEpoll()) : new NettyNativeDetector(EpollDetector.hasEpoll())) : new NettyNativeDetector(false);
    final boolean epoll;

    NettyNativeDetector(boolean epoll) {
        this.epoll = epoll;
    }

    public static NettyNativeDetector instance() {
        return DEFAULT;
    }

    public static NettyNativeDetector force(boolean _native) {
        return new NettyNativeDetector(_native);
    }

    public EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory) {
        return this.epoll ? EpollDetector.newEventLoopGroup(threads, factory) : new NioEventLoopGroup(threads, factory);
    }

    public Class<? extends ServerChannel> getServerChannel(EventLoopGroup group) {
        return this.epoll ? EpollDetector.getServerChannel(group) : NioServerSocketChannel.class;
    }

    public Class<? extends Channel> getChannel(EventLoopGroup group) {
        return this.epoll ? EpollDetector.getChannel(group) : NioSocketChannel.class;
    }

    public Class<? extends Channel> getDatagramChannel(EventLoopGroup group) {
        return this.epoll ? EpollDetector.getDatagramChannel(group) : NioDatagramChannel.class;
    }

    static {
        Loggers.getLogger(NettyNativeDetector.class).debug("Default Netty Epoll support : " + NettyNativeDetector.DEFAULT.epoll);
    }
}

