/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.DefaultFileRegion;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.connector.Outbound;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyPipeline;
import reactor.ipc.netty.ReactorNetty;

public interface NettyOutbound
extends Outbound<ByteBuf>,
Publisher<Void> {
    default public ByteBufAllocator alloc() {
        return this.context().channel().alloc();
    }

    default public NettyOutbound options(Consumer<? super NettyPipeline.SendOptions> configurator) {
        this.context().channel().pipeline().fireUserEventTriggered((Object)new NettyPipeline.SendOptionsChangeEvent(configurator, null));
        return this;
    }

    public NettyContext context();

    default public NettyOutbound onWriteIdle(long idleTimeout, Runnable onWriteIdle) {
        this.context().addHandler("onChannelWriteIdle", (ChannelHandler)new ReactorNetty.OutboundIdleStateHandler(idleTimeout, onWriteIdle));
        return this;
    }

    default public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject(dataStream);
    }

    default public NettyOutbound sendByteArray(Publisher<? extends byte[]> dataStream) {
        return this.sendObject((Publisher<?>)Flux.from(dataStream).map(Unpooled::wrappedBuffer));
    }

    default public NettyOutbound sendFile(Path file) {
        try {
            return this.sendFile(file, 0L, Files.size(file));
        }
        catch (IOException e) {
            return this.then((Publisher)Mono.error((Throwable)e));
        }
    }

    default public NettyOutbound sendFile(Path file, long position, long count) {
        Objects.requireNonNull(file);
        return this.then((Publisher)Mono.using(() -> FileChannel.open(file, StandardOpenOption.READ), fc -> FutureMono.from(this.context().channel().writeAndFlush((Object)new DefaultFileRegion(fc, position, count))), fc -> {
            try {
                fc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }

    default public NettyOutbound sendGroups(Publisher<? extends Publisher<? extends ByteBuf>> dataStreams) {
        return this.then((Publisher)Flux.from(dataStreams).concatMapDelayError(publisher -> this.send((Publisher)publisher), false, 32).then());
    }

    default public NettyOutbound sendObject(Publisher<?> dataStream) {
        return this.then((Publisher)FutureMono.deferFuture(() -> this.context().channel().writeAndFlush((Object)dataStream)));
    }

    default public NettyOutbound sendObject(Object msg) {
        return this.then((Publisher)FutureMono.deferFuture(() -> this.context().channel().writeAndFlush(msg)));
    }

    default public NettyOutbound sendString(Publisher<? extends String> dataStream) {
        return this.sendString(dataStream, Charset.defaultCharset());
    }

    default public NettyOutbound sendString(Publisher<? extends String> dataStream, Charset charset) {
        return this.sendObject((Publisher<?>)Flux.from(dataStream).map(s -> this.alloc().buffer().writeBytes(s.getBytes(charset))));
    }

    default public void subscribe(Subscriber<? super Void> s) {
        this.then().subscribe(s);
    }

    default public NettyOutbound then(Publisher<Void> other) {
        return new ReactorNetty.OutboundThen(this, other);
    }
}

