/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty;

import java.util.Objects;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.ipc.netty.ReactorNetty;

public interface NettyPipeline {
    public static final String SslHandler = "sslHandler";
    public static final String SslReader = "sslReader";
    public static final String SslLoggingHandler = "sslLoggingHandler";
    public static final String ProxyHandler = "proxyHandler";
    public static final String ReactiveBridge = "reactiveBridge";
    public static final String BridgeSetup = "bridgeSetup";
    public static final String HttpEncoder = "httpEncoder";
    public static final String HttpDecoder = "httpDecoder";
    public static final String HttpAggregator = "reactorHttpAggregator";
    public static final String HttpServerHandler = "httpServerHandler";
    public static final String OnChannelWriteIdle = "onChannelWriteIdle";
    public static final String OnChannelReadIdle = "onChannelReadIdle";
    public static final String ChunkedWriter = "chunkedWriter";
    public static final String LoggingHandler = "loggingHandler";

    public static Object handlerTerminatedEvent() {
        return ReactorNetty.TERMINATED;
    }

    public static final class SendOptionsChangeEvent {
        final Consumer<? super SendOptions> configurator;
        final Publisher<?> source;

        SendOptionsChangeEvent(Consumer<? super SendOptions> configurator, Publisher<?> source) {
            this.configurator = Objects.requireNonNull(configurator, "configurator");
            this.source = source;
        }

        public Consumer<? super SendOptions> configurator() {
            return this.configurator;
        }
    }

    public static interface SendOptions {
        public SendOptions flushOnBoundary();

        public SendOptions flushOnEach();
    }
}

