/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyOutbound;

final class ReactorNetty {
    static final Object TERMINATED = new TerminatedHandlerEvent();

    ReactorNetty() {
    }

    static final class InboundIdleStateHandler
    extends IdleStateHandler {
        final Runnable onReadIdle;

        InboundIdleStateHandler(long idleTimeout, Runnable onReadIdle) {
            super(idleTimeout, 0L, 0L, TimeUnit.MILLISECONDS);
            this.onReadIdle = onReadIdle;
        }

        protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            if (evt.state() == IdleState.READER_IDLE) {
                this.onReadIdle.run();
            }
            super.channelIdle(ctx, evt);
        }
    }

    static final class OutboundIdleStateHandler
    extends IdleStateHandler {
        final Runnable onWriteIdle;

        OutboundIdleStateHandler(long idleTimeout, Runnable onWriteIdle) {
            super(0L, idleTimeout, 0L, TimeUnit.MILLISECONDS);
            this.onWriteIdle = onWriteIdle;
        }

        protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
            if (evt.state() == IdleState.WRITER_IDLE) {
                this.onWriteIdle.run();
            }
            super.channelIdle(ctx, evt);
        }
    }

    static final class OutboundThen
    implements NettyOutbound {
        final NettyContext sourceContext;
        final Mono<Void> thenMono;

        OutboundThen(NettyOutbound source, Publisher<Void> thenPublisher) {
            this.sourceContext = source.context();
            Mono parentMono = source.then();
            this.thenMono = parentMono == Mono.empty() ? Mono.from(thenPublisher) : parentMono.thenEmpty(thenPublisher);
        }

        @Override
        public NettyContext context() {
            return this.sourceContext;
        }

        public Mono<Void> then() {
            return this.thenMono;
        }
    }

    static final class TerminatedHandlerEvent {
        TerminatedHandlerEvent() {
        }

        public String toString() {
            return "[Handler Terminated]";
        }
    }
}

