/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

@ChannelHandler.Sharable
final class ByteBufHolderHandler
extends ChannelInboundHandlerAdapter {
    static final ByteBufHolderHandler INSTANCE = new ByteBufHolderHandler();

    ByteBufHolderHandler() {
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBufHolder) {
            ByteBuf bb = ((ByteBufHolder)msg).content();
            if (bb == Unpooled.EMPTY_BUFFER || bb instanceof EmptyByteBuf) {
                ctx.fireChannelRead(msg);
            } else {
                ctx.fireChannelRead((Object)bb.retain());
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }
}

