/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.ProxyHandler;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.CloseableContextHandler;
import reactor.ipc.netty.options.ClientOptions;

final class ClientContextHandler<CHANNEL extends Channel>
extends CloseableContextHandler<CHANNEL> {
    final ClientOptions clientOptions;
    final boolean secure;

    ClientContextHandler(ChannelOperations.OnNew<CHANNEL> channelOpFactory, ClientOptions options, MonoSink<NettyContext> sink, LoggingHandler loggingHandler, boolean secure) {
        super(channelOpFactory, options, sink, loggingHandler);
        this.clientOptions = options;
        this.secure = secure;
    }

    @Override
    public final void fireContextActive(NettyContext context) {
        if (!this.fired) {
            this.fired = true;
            this.sink.success((Object)context);
        }
    }

    @Override
    protected void doDropped(Channel channel) {
        channel.close();
        if (!this.fired) {
            this.fired = true;
            this.sink.error((Throwable)ABORTED);
        }
    }

    @Override
    protected void doPipeline(ChannelPipeline pipeline) {
        ClientContextHandler.addSslAndLogHandlers(this.clientOptions, (MonoSink<NettyContext>)this.sink, this.loggingHandler, this.secure, pipeline);
        ClientContextHandler.addProxyHandler(this.clientOptions, pipeline);
    }

    static void addProxyHandler(ClientOptions clientOptions, ChannelPipeline pipeline) {
        ProxyHandler proxy = clientOptions.getProxyHandler();
        if (proxy != null) {
            pipeline.addFirst("proxyHandler", (ChannelHandler)proxy);
        }
    }
}

