/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.Cancellation;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.options.NettyOptions;
import reactor.util.Logger;
import reactor.util.Loggers;

abstract class CloseableContextHandler<CHANNEL extends Channel>
extends ContextHandler<CHANNEL>
implements ChannelFutureListener {
    static final Logger log = Loggers.getLogger(CloseableContextHandler.class);
    ChannelFuture f;

    CloseableContextHandler(ChannelOperations.OnNew<CHANNEL> channelOpFactory, NettyOptions<?, ?> options, MonoSink<NettyContext> sink, LoggingHandler loggingHandler) {
        super(channelOpFactory, options, sink, loggingHandler);
    }

    @Override
    protected Publisher<Void> onCloseOrRelease(Channel channel) {
        return FutureMono.from(channel.closeFuture());
    }

    public final void operationComplete(ChannelFuture f) throws Exception {
        if (!f.isSuccess()) {
            if (f.isCancelled()) {
                log.debug("Cancelled {}", new Object[]{f.channel().toString()});
                return;
            }
            if (f.cause() != null) {
                this.sink.error(f.cause());
            } else {
                this.sink.error((Throwable)new IOException("error while connecting to " + f.channel().toString()));
            }
        } else {
            this.doStarted(f.channel());
        }
    }

    @Override
    public final void setFuture(Future<?> future) {
        Objects.requireNonNull(future, "future");
        if (this.f != null) {
            future.cancel(true);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Connecting new channel: {}", new Object[]{future.toString()});
        }
        this.f = (ChannelFuture)future;
        this.f.addListener((GenericFutureListener)this);
        this.sink.setCancellation((Cancellation)this);
    }

    public final void dispose() {
        if (this.f == null) {
            return;
        }
        if (this.f.channel().isOpen()) {
            this.f.channel().close();
        } else if (!this.f.isDone()) {
            this.f.cancel(true);
        }
    }
}

