/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.pool.ChannelPool;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.channel.AbortedException;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.ChannelOperationsHandler;
import reactor.ipc.netty.channel.ClientContextHandler;
import reactor.ipc.netty.channel.PooledClientContextHandler;
import reactor.ipc.netty.channel.ServerContextHandler;
import reactor.ipc.netty.channel.SslReadHandler;
import reactor.ipc.netty.options.ClientOptions;
import reactor.ipc.netty.options.NettyOptions;
import reactor.ipc.netty.options.ServerOptions;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class ContextHandler<CHANNEL extends Channel>
extends ChannelInitializer<CHANNEL>
implements Disposable {
    final MonoSink<NettyContext> sink;
    final NettyOptions<?, ?> options;
    final LoggingHandler loggingHandler;
    final ChannelOperations.OnNew<CHANNEL> channelOpFactory;
    BiConsumer<ChannelPipeline, ContextHandler<Channel>> pipelineConfigurator;
    boolean fired;
    boolean autoCreateOperations;
    static final AbortedException ABORTED = new AbortedException(){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };
    static final Logger log = Loggers.getLogger(ContextHandler.class);
    static final AttributeKey<Boolean> CLOSE_CHANNEL = AttributeKey.newInstance((String)"CLOSE_CHANNEL");

    public static <CHANNEL extends Channel> ContextHandler<CHANNEL> newClientContext(MonoSink<NettyContext> sink, ClientOptions options, LoggingHandler loggingHandler, boolean secure, ChannelOperations.OnNew<CHANNEL> channelOpFactory) {
        return ContextHandler.newClientContext(sink, options, loggingHandler, secure, null, channelOpFactory);
    }

    public static <CHANNEL extends Channel> ContextHandler<CHANNEL> newClientContext(MonoSink<NettyContext> sink, ClientOptions options, LoggingHandler loggingHandler, boolean secure, ChannelPool pool, ChannelOperations.OnNew<CHANNEL> channelOpFactory) {
        if (pool != null) {
            return new PooledClientContextHandler<CHANNEL>(channelOpFactory, options, sink, loggingHandler, secure, pool);
        }
        return new ClientContextHandler<CHANNEL>(channelOpFactory, options, sink, loggingHandler, secure);
    }

    public static ContextHandler<Channel> newServerContext(MonoSink<NettyContext> sink, ServerOptions options, LoggingHandler loggingHandler, ChannelOperations.OnNew<Channel> channelOpFactory) {
        return new ServerContextHandler(channelOpFactory, options, sink, loggingHandler);
    }

    protected ContextHandler(ChannelOperations.OnNew<CHANNEL> channelOpFactory, NettyOptions<?, ?> options, MonoSink<NettyContext> sink, LoggingHandler loggingHandler) {
        this.options = options;
        this.channelOpFactory = Objects.requireNonNull(channelOpFactory, "channelOpFactory");
        this.sink = sink;
        this.loggingHandler = loggingHandler;
        this.autoCreateOperations = true;
    }

    public final ContextHandler<CHANNEL> onPipeline(BiConsumer<ChannelPipeline, ContextHandler<Channel>> pipelineConfigurator) {
        this.pipelineConfigurator = Objects.requireNonNull(pipelineConfigurator, "pipelineConfigurator");
        return this;
    }

    public final ContextHandler<CHANNEL> autoCreateOperations(boolean autoCreateOperations) {
        this.autoCreateOperations = autoCreateOperations;
        return this;
    }

    public final ChannelOperations<?, ?> createOperations(Channel channel, Object msg) {
        if (this.autoCreateOperations || msg != null) {
            ChannelOperations<?, ?> op = this.channelOpFactory.create(channel, this, msg);
            channel.attr(ChannelOperations.OPERATIONS_KEY).set(op);
            channel.eventLoop().execute(op::onHandlerStart);
            return op;
        }
        return null;
    }

    public abstract void fireContextActive(NettyContext var1);

    public void fireContextError(Throwable t) {
        if (!this.fired) {
            this.fired = true;
            this.sink.error(t);
        }
    }

    public abstract void setFuture(Future<?> var1);

    protected void doStarted(Channel channel) {
    }

    protected void initChannel(CHANNEL ch) throws Exception {
        this.doPipeline(ch.pipeline());
        ch.pipeline().addLast("bridgeSetup", (ChannelHandler)new BridgeSetupHandler(this));
        if (log.isDebugEnabled()) {
            log.debug("After pipeline {}", new Object[]{ch.pipeline().toString()});
        }
    }

    protected void doDropped(Channel channel) {
    }

    protected abstract void doPipeline(ChannelPipeline var1);

    protected void terminateChannel(Channel channel) {
        this.dispose();
    }

    protected abstract Publisher<Void> onCloseOrRelease(Channel var1);

    static void addSslAndLogHandlers(NettyOptions<?, ?> options, MonoSink<NettyContext> sink, LoggingHandler loggingHandler, boolean secure, ChannelPipeline pipeline) {
        SslHandler sslHandler;
        SslHandler sslHandler2 = sslHandler = secure ? options.getSslHandler(pipeline.channel().alloc()) : null;
        if (sslHandler != null) {
            if (log.isDebugEnabled()) {
                log.debug("SSL enabled using engine {}", new Object[]{sslHandler.engine().getClass().getSimpleName()});
            }
            if (log.isTraceEnabled()) {
                pipeline.addFirst("sslLoggingHandler", (ChannelHandler)new LoggingHandler(SslReadHandler.class));
                pipeline.addAfter("sslLoggingHandler", "sslHandler", (ChannelHandler)sslHandler);
            } else {
                pipeline.addFirst("sslHandler", (ChannelHandler)sslHandler);
            }
            if (log.isDebugEnabled()) {
                pipeline.addAfter("sslHandler", "loggingHandler", (ChannelHandler)loggingHandler);
                pipeline.addAfter("loggingHandler", "sslReader", (ChannelHandler)new SslReadHandler(sink));
            } else {
                pipeline.addAfter("sslHandler", "sslReader", (ChannelHandler)new SslReadHandler(sink));
            }
        } else if (log.isDebugEnabled()) {
            pipeline.addFirst("loggingHandler", (ChannelHandler)loggingHandler);
        }
    }

    static final class BridgeSetupHandler
    extends ChannelInboundHandlerAdapter {
        final ContextHandler<Channel> parent;
        boolean active;

        BridgeSetupHandler(ContextHandler<?> parent) {
            this.parent = parent;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (!this.active) {
                this.active = true;
                if (this.parent.options.onChannelInit() != null && this.parent.options.onChannelInit().test(ctx.channel())) {
                    if (log.isDebugEnabled()) {
                        log.debug("DROPPED by onChannelInit predicate {}", new Object[]{ctx.channel()});
                    }
                    this.parent.doDropped(ctx.channel());
                    return;
                }
                try {
                    if (this.parent.pipelineConfigurator != null) {
                        this.parent.pipelineConfigurator.accept(ctx.pipeline(), this.parent);
                    }
                    ctx.pipeline().addLast("reactiveBridge", (ChannelHandler)new ChannelOperationsHandler(this.parent));
                }
                catch (Exception t) {
                    if (log.isErrorEnabled()) {
                        log.error("Error while binding a channelOperation with: " + ctx.channel().toString() + " on " + ctx.pipeline(), (Throwable)t);
                    }
                }
                finally {
                    if (null != this.parent.options.afterChannelInit()) {
                        this.parent.options.afterChannelInit().accept(ctx.channel());
                    }
                }
                ctx.pipeline().remove((ChannelHandler)this);
            }
            ctx.fireChannelActive();
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (!this.active) {
                ctx.pipeline().remove((ChannelHandler)this);
                this.parent.terminateChannel(ctx.channel());
                this.parent.fireContextError(ABORTED);
            }
            ctx.fireChannelInactive();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (!this.active) {
                if (log.isErrorEnabled()) {
                    log.error("Error while binding a channelOperation with: " + ctx.channel().toString(), cause);
                }
                ctx.pipeline().remove((ChannelHandler)this);
                this.parent.terminateChannel(ctx.channel());
                this.parent.fireContextError(cause);
            }
            ctx.fireExceptionCaught(cause);
        }
    }
}

