/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.util.ReferenceCountUtil;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.Producer;
import reactor.core.Trackable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.concurrent.QueueSupplier;

final class FluxReceive
extends Flux<Object>
implements Subscription,
Trackable,
Producer {
    final Channel channel;
    final ChannelOperations<?, ?> parent;
    final EventLoop eventLoop;
    Subscriber<? super Object> receiver;
    boolean receiverFastpath;
    long receiverDemand;
    Queue<Object> receiverQueue;
    boolean inboundDone;
    Throwable inboundError;
    volatile Disposable receiverCancel;
    static final AtomicReferenceFieldUpdater<FluxReceive, Disposable> CANCEL = AtomicReferenceFieldUpdater.newUpdater(FluxReceive.class, Disposable.class, "receiverCancel");
    static final Disposable CANCELLED = () -> {};
    static final Logger log = Loggers.getLogger(FluxReceive.class);

    FluxReceive(ChannelOperations<?, ?> parent) {
        this.parent = parent;
        this.channel = parent.channel;
        this.eventLoop = this.channel.eventLoop();
    }

    public void cancel() {
        Queue<Object> q;
        if (this.cancelReceiver() && (q = this.receiverQueue) != null) {
            Object o;
            while ((o = q.poll()) != null) {
                ReferenceCountUtil.release((Object)o);
            }
        }
    }

    public final Object downstream() {
        return this.receiver;
    }

    public final Throwable getError() {
        return this.inboundError;
    }

    public long getPending() {
        return this.receiverQueue != null ? (long)this.receiverQueue.size() : 0L;
    }

    public final boolean isStarted() {
        return this.channel.isActive();
    }

    public final boolean isTerminated() {
        return this.inboundDone;
    }

    public boolean isCancelled() {
        return this.receiverCancel == CANCELLED;
    }

    public void request(long n) {
        if (Operators.validate((long)n)) {
            if (this.eventLoop.inEventLoop()) {
                this.receiverDemand = Operators.addCap((long)this.receiverDemand, (long)n);
                this.drainReceiver();
            } else {
                this.eventLoop.execute(() -> {
                    this.receiverDemand = Operators.addCap((long)this.receiverDemand, (long)n);
                    this.drainReceiver();
                });
            }
        }
    }

    public long requestedFromDownstream() {
        return this.receiverDemand;
    }

    public void subscribe(Subscriber<? super Object> s) {
        if (s == null) {
            throw Exceptions.argumentIsNullException();
        }
        if (this.eventLoop.inEventLoop()) {
            this.startReceiver(s);
        } else {
            this.eventLoop.execute(() -> this.startReceiver(s));
        }
    }

    final boolean cancelReceiver() {
        Disposable c = this.receiverCancel;
        if (c != CANCELLED && (c = CANCEL.getAndSet(this, CANCELLED)) != CANCELLED) {
            this.channel.config().setAutoRead(false);
            if (this.parent.isOutboundDone()) {
                this.parent.onHandlerTerminate();
            } else {
                this.parent.onInboundCancel();
            }
            if (c != null) {
                c.dispose();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean drainReceiver() {
        long e;
        Queue<Object> q = this.receiverQueue;
        Subscriber<? super Object> a = this.receiver;
        if (a == null) {
            if (this.inboundDone) {
                this.cancelReceiver();
            }
            return false;
        }
        long r = this.receiverDemand;
        for (e = 0L; e != r; ++e) {
            boolean empty;
            if (this.isCancelled()) {
                return false;
            }
            boolean d = this.inboundDone;
            Object v = q != null ? q.poll() : null;
            boolean bl = empty = v == null;
            if (d && empty) {
                this.terminateReceiver(q, a);
                return false;
            }
            if (empty) break;
            try {
                a.onNext(v);
                continue;
            }
            finally {
                ReferenceCountUtil.release((Object)v);
            }
        }
        if (this.isCancelled()) {
            return false;
        }
        if (this.inboundDone && (q == null || q.isEmpty())) {
            this.terminateReceiver(q, a);
            return false;
        }
        if (r == Long.MAX_VALUE) {
            this.channel.config().setAutoRead(true);
            this.channel.read();
            return true;
        }
        if ((this.receiverDemand -= e) > 0L || e > 0L) {
            this.channel.read();
        }
        return false;
    }

    final void startReceiver(Subscriber<? super Object> s) {
        if (this.receiver == null) {
            if (log.isDebugEnabled()) {
                log.debug("Subscribing inbound receiver [pending: " + this.getPending() + ", inboundDone: {}]", new Object[]{this.inboundDone});
            }
            if (this.inboundDone && this.getPending() == 0L) {
                if (this.inboundError != null) {
                    Operators.error(s, (Throwable)this.inboundError);
                    return;
                }
                Operators.complete(s);
                return;
            }
            this.receiver = s;
            CANCEL.lazySet(this, () -> {
                if (this.eventLoop.inEventLoop()) {
                    this.unsubscribeReceiver();
                } else {
                    this.eventLoop.execute(this::unsubscribeReceiver);
                }
            });
            s.onSubscribe((Subscription)this);
        } else {
            Operators.error(s, (Throwable)new IllegalStateException("Only one connection receive subscriber allowed."));
        }
    }

    final boolean markInboundDone() {
        if (this.inboundDone) {
            Queue<Object> q = this.receiverQueue;
            Subscriber<? super Object> receiver = this.receiver;
            if (receiver == null && (q == null || q.isEmpty())) {
                this.cancel();
                return true;
            }
            return false;
        }
        this.inboundDone = true;
        return false;
    }

    final void onInboundNext(Object msg) {
        if (this.inboundDone) {
            if (log.isDebugEnabled()) {
                log.debug("Dropping frame {}", new Object[]{msg});
            }
            return;
        }
        ReferenceCountUtil.retain((Object)msg);
        if (this.receiverFastpath && this.receiver != null) {
            try {
                this.receiver.onNext(msg);
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        } else {
            Queue q = this.receiverQueue;
            if (q == null) {
                this.receiverQueue = q = (Queue)QueueSupplier.unbounded().get();
            }
            q.offer((Object)msg);
            if (this.drainReceiver()) {
                this.receiverFastpath = true;
            }
        }
    }

    final boolean onInboundComplete() {
        if (this.inboundDone) {
            return false;
        }
        this.inboundDone = true;
        Subscriber<? super Object> receiver = this.receiver;
        if (this.receiverFastpath && receiver != null) {
            receiver.onComplete();
            this.cancelReceiver();
            return true;
        }
        this.drainReceiver();
        return false;
    }

    final boolean onInboundError(Throwable err) {
        if (this.isCancelled() || this.inboundDone) {
            Operators.onErrorDropped((Throwable)err);
            return false;
        }
        this.inboundDone = true;
        Subscriber<? super Object> receiver = this.receiver;
        this.inboundError = err;
        if (this.receiverFastpath && receiver != null) {
            this.cancelReceiver();
            receiver.onError(err);
            return true;
        }
        this.drainReceiver();
        return false;
    }

    final void terminateReceiver(Queue<?> q, Subscriber<?> a) {
        Throwable ex;
        this.cancelReceiver();
        if (q != null) {
            q.clear();
        }
        if ((ex = this.inboundError) != null) {
            a.onError(ex);
        } else {
            a.onComplete();
        }
        this.parent.context.fireContextActive(this.parent);
    }

    final void unsubscribeReceiver() {
        this.receiverDemand = 0L;
        this.receiver = null;
    }
}

