/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.CloseableContextHandler;
import reactor.ipc.netty.options.ServerOptions;

final class ServerContextHandler
extends CloseableContextHandler<Channel>
implements NettyContext {
    final ServerOptions serverOptions;

    ServerContextHandler(ChannelOperations.OnNew<Channel> channelOpFactory, ServerOptions options, MonoSink<NettyContext> sink, LoggingHandler loggingHandler) {
        super(channelOpFactory, options, sink, loggingHandler);
        this.serverOptions = options;
    }

    @Override
    protected void doStarted(Channel channel) {
        this.sink.success((Object)this);
    }

    @Override
    public final void fireContextActive(NettyContext context) {
    }

    @Override
    public void fireContextError(Throwable t) {
    }

    @Override
    public InetSocketAddress address() {
        Channel c = this.f.channel();
        if (c instanceof SocketChannel) {
            return ((SocketChannel)c).remoteAddress();
        }
        if (c instanceof ServerSocketChannel) {
            return ((ServerSocketChannel)c).localAddress();
        }
        if (c instanceof DatagramChannel) {
            return ((DatagramChannel)c).localAddress();
        }
        throw new IllegalStateException("Does not have an InetSocketAddress");
    }

    @Override
    public NettyContext addHandler(String name, ChannelHandler handler) {
        if (this.channel().pipeline().context(name) == null) {
            this.channel().pipeline().addLast(name, handler);
        }
        return this;
    }

    @Override
    public NettyContext onClose(Runnable onClose) {
        this.onClose().subscribe(null, e -> onClose.run(), onClose);
        return this;
    }

    @Override
    public Channel channel() {
        return this.f.channel();
    }

    public boolean isDisposed() {
        return !this.f.channel().isOpen();
    }

    @Override
    public Mono<Void> onClose() {
        return FutureMono.from(this.f.channel().closeFuture());
    }

    @Override
    public void terminateChannel(Channel channel) {
        if (!this.f.channel().isOpen()) {
            return;
        }
        Boolean attr = (Boolean)channel.attr(CLOSE_CHANNEL).get();
        if (attr != null && attr.booleanValue()) {
            channel.close();
        }
    }

    @Override
    protected void doPipeline(ChannelPipeline pipeline) {
        ServerContextHandler.addSslAndLogHandlers(this.options, (MonoSink<NettyContext>)this.sink, this.loggingHandler, true, pipeline);
    }
}

