/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyConnector;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.http.HttpResources;
import reactor.ipc.netty.http.client.HttpClientOperations;
import reactor.ipc.netty.http.client.HttpClientOptions;
import reactor.ipc.netty.http.client.HttpClientRequest;
import reactor.ipc.netty.http.client.HttpClientResponse;
import reactor.ipc.netty.http.client.MonoHttpClientResponse;
import reactor.ipc.netty.options.ClientOptions;
import reactor.ipc.netty.tcp.TcpClient;

public class HttpClient
implements NettyConnector<HttpClientResponse, HttpClientRequest> {
    final TcpBridgeClient client;
    final HttpClientOptions options;
    static final HttpMethod WS = new HttpMethod("WS");
    static final String WS_SCHEME = "ws";
    static final String WSS_SCHEME = "wss";
    static final String HTTP_SCHEME = "http";
    static final String HTTPS_SCHEME = "https";
    static final LoggingHandler loggingHandler = new LoggingHandler(HttpClient.class);

    public static HttpClient create() {
        return HttpClient.create(HttpClientOptions::sslSupport);
    }

    public static HttpClient create(Consumer<? super HttpClientOptions> options) {
        Objects.requireNonNull(options, "options");
        HttpClientOptions clientOptions = HttpClientOptions.create();
        clientOptions.loopResources(HttpResources.get()).poolResources(HttpResources.get());
        options.accept(clientOptions);
        return new HttpClient(clientOptions.duplicate());
    }

    public static HttpClient create(String address) {
        return HttpClient.create(address, 80);
    }

    public static HttpClient create(String address, int port) {
        return HttpClient.create((? super HttpClientOptions opts) -> opts.connect(address, port));
    }

    public static HttpClient create(int port) {
        return HttpClient.create("localhost", port);
    }

    protected HttpClient(HttpClientOptions options) {
        this.client = new TcpBridgeClient(options);
        this.options = options;
    }

    public final Mono<HttpClientResponse> delete(String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        return this.request(HttpMethod.DELETE, url, handler);
    }

    public final Mono<HttpClientResponse> delete(String url) {
        return this.request(HttpMethod.DELETE, url, null);
    }

    public final Mono<HttpClientResponse> get(String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        return this.request(HttpMethod.GET, url, handler);
    }

    public final Mono<HttpClientResponse> get(String url) {
        return this.request(HttpMethod.GET, url, null);
    }

    public Mono<HttpClientResponse> newHandler(BiFunction<? super HttpClientResponse, ? super HttpClientRequest, ? extends Publisher<Void>> ioHandler) {
        return this.client.newHandler(ioHandler);
    }

    public final Mono<HttpClientResponse> patch(String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        return this.request(HttpMethod.PATCH, url, handler);
    }

    public final Mono<HttpClientResponse> patch(String url) {
        return this.request(HttpMethod.PATCH, url, null);
    }

    public final Mono<HttpClientResponse> post(String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        return this.request(HttpMethod.POST, url, handler);
    }

    public final Mono<HttpClientResponse> put(String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        return this.request(HttpMethod.PUT, url, handler);
    }

    public Mono<HttpClientResponse> request(HttpMethod method, String url, Function<? super HttpClientRequest, ? extends Publisher<Void>> handler) {
        if (method == null || url == null) {
            throw new IllegalArgumentException("Method && url cannot be both null");
        }
        return new MonoHttpClientResponse(this, url, method, handler);
    }

    public final Mono<HttpClientResponse> ws(String url) {
        return this.request(WS, url, HttpClientRequest::sendWebsocket);
    }

    public final Mono<HttpClientResponse> ws(String url, Consumer<? super HttpHeaders> headerBuilder) {
        return this.request(WS, url, ch -> {
            headerBuilder.accept(ch.requestHeaders());
            return ch.sendWebsocket();
        });
    }

    final class TcpBridgeClient
    extends TcpClient
    implements BiConsumer<ChannelPipeline, ContextHandler<Channel>> {
        TcpBridgeClient(ClientOptions options) {
            super(options);
        }

        @Override
        protected Mono<NettyContext> newHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler, InetSocketAddress address, boolean secure, Consumer<? super Channel> onSetup) {
            return super.newHandler(handler, address, secure, onSetup);
        }

        @Override
        protected ContextHandler<SocketChannel> doHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler, MonoSink<NettyContext> sink, boolean secure, ChannelPool pool, Consumer<? super Channel> onSetup) {
            return ContextHandler.newClientContext(sink, HttpClient.this.options, loggingHandler, secure, pool, (ch, c, msg) -> {
                if (onSetup != null) {
                    onSetup.accept(ch);
                }
                return HttpClientOperations.bindHttp(ch, handler, c);
            }).onPipeline(this);
        }

        @Override
        public void accept(ChannelPipeline pipeline, ContextHandler<Channel> c) {
            pipeline.addLast("httpDecoder", (ChannelHandler)new HttpResponseDecoder()).addLast("httpEncoder", (ChannelHandler)new HttpRequestEncoder());
        }
    }
}

