/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.internal.ThreadLocalRandom;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import reactor.core.Exceptions;
import reactor.core.publisher.DirectProcessor;
import reactor.ipc.netty.http.client.HttpClientRequest;

final class HttpClientFormEncoder
implements ChunkedInput<HttpContent>,
Runnable,
HttpClientRequest.Form {
    final HttpDataFactory factory;
    final HttpRequest request;
    final Charset charset;
    final List<InterfaceHttpData> bodyListDatas;
    final List<InterfaceHttpData> multipartHttpDatas;
    final boolean isMultipart;
    final HttpPostRequestEncoder.EncoderMode encoderMode;
    final DirectProcessor<Long> progressFlux;
    boolean cleanOnTerminate;
    boolean needNewEncoder;
    boolean isChunked;
    String multipartDataBoundary;
    String multipartMixedBoundary;
    boolean headerFinalized;
    boolean isLastChunk;
    boolean isLastChunkSent;
    FileUpload currentFileUpload;
    boolean duringMixedMode;
    long globalBodySize;
    long globalProgress;
    ListIterator<InterfaceHttpData> iterator;
    ByteBuf currentBuffer;
    InterfaceHttpData currentData;
    boolean isKey = true;
    Charset newCharset;
    boolean newMultipart;
    HttpPostRequestEncoder.EncoderMode newMode;
    static final Map<Pattern, String> percentEncodings = new HashMap<Pattern, String>();
    static final String DEFAULT_BINARY_CONTENT_TYPE = "application/octet-stream";
    static final String DEFAULT_TRANSFER_ENCODING = "binary";
    static final String DEFAULT_TEXT_CONTENT_TYPE = "text/plain";
    static final int chunkSize = 8096;

    HttpClientFormEncoder(HttpDataFactory factory, HttpRequest request, boolean multipart, Charset charset, HttpPostRequestEncoder.EncoderMode encoderMode) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        HttpMethod method = request.method();
        if (!(method.equals((Object)HttpMethod.POST) || method.equals((Object)HttpMethod.PUT) || method.equals((Object)HttpMethod.PATCH) || method.equals((Object)HttpMethod.OPTIONS))) {
            throw new HttpPostRequestEncoder.ErrorDataEncoderException("Cannot create a Encoder if not a POST");
        }
        this.request = request;
        this.charset = charset;
        this.newCharset = charset;
        this.factory = factory;
        this.progressFlux = DirectProcessor.create();
        this.cleanOnTerminate = true;
        this.newMode = encoderMode;
        this.newMultipart = multipart;
        this.bodyListDatas = new ArrayList<InterfaceHttpData>();
        this.isLastChunk = false;
        this.isLastChunkSent = false;
        this.isMultipart = multipart;
        this.multipartHttpDatas = new ArrayList<InterfaceHttpData>();
        this.encoderMode = encoderMode;
        if (this.isMultipart) {
            this.initDataMultipart();
        }
    }

    public void close() throws Exception {
    }

    public boolean isEndOfInput() throws Exception {
        return this.isLastChunkSent;
    }

    public long length() {
        return this.isMultipart ? this.globalBodySize : this.globalBodySize - 1L;
    }

    public long progress() {
        return this.globalProgress;
    }

    @Deprecated
    public HttpContent readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    public HttpContent readChunk(ByteBufAllocator allocator) throws Exception {
        if (this.isLastChunkSent) {
            this.progressFlux.onComplete();
            return null;
        }
        HttpContent nextChunk = this.nextChunk();
        this.globalProgress += (long)nextChunk.content().readableBytes();
        this.progressFlux.onNext((Object)this.progress());
        if (this.isLastChunkSent) {
            this.progressFlux.onComplete();
        }
        return nextChunk;
    }

    void addBodyAttribute(String name, String value) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String svalue = value;
        if (value == null) {
            svalue = "";
        }
        Attribute data = this.factory.createAttribute(this.request, name, svalue);
        this.addBodyHttpData((InterfaceHttpData)data);
    }

    void addBodyFileUpload(String name, File file, String contentType, boolean isText) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (file == null) {
            throw new NullPointerException("file");
        }
        String scontentType = contentType;
        String contentTransferEncoding = null;
        if (contentType == null) {
            scontentType = isText ? DEFAULT_TEXT_CONTENT_TYPE : DEFAULT_BINARY_CONTENT_TYPE;
        }
        if (!isText) {
            contentTransferEncoding = DEFAULT_TRANSFER_ENCODING;
        }
        FileUpload fileUpload = this.factory.createFileUpload(this.request, name, file.getName(), scontentType, contentTransferEncoding, null, file.length());
        try {
            fileUpload.setContent(file);
        }
        catch (IOException e) {
            throw new HttpPostRequestEncoder.ErrorDataEncoderException((Throwable)e);
        }
        this.addBodyHttpData((InterfaceHttpData)fileUpload);
    }

    void addBodyFileUploads(String name, File[] file, String[] contentType, boolean[] isText) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        if (file.length != contentType.length && file.length != isText.length) {
            throw new NullPointerException("Different array length");
        }
        for (int i = 0; i < file.length; ++i) {
            this.addBodyFileUpload(name, file[i], contentType[i], isText[i]);
        }
    }

    void addBodyHttpData(InterfaceHttpData data) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        if (this.headerFinalized) {
            throw new HttpPostRequestEncoder.ErrorDataEncoderException("Cannot add value once finalized");
        }
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.bodyListDatas.add(data);
        if (!this.isMultipart) {
            if (data instanceof Attribute) {
                Attribute attribute = (Attribute)data;
                try {
                    String key = this.encodeAttribute(attribute.getName(), this.charset);
                    String value = this.encodeAttribute(attribute.getValue(), this.charset);
                    Attribute newattribute = this.factory.createAttribute(this.request, key, value);
                    this.multipartHttpDatas.add((InterfaceHttpData)newattribute);
                    this.globalBodySize += (long)(newattribute.getName().length() + 1) + newattribute.length() + 1L;
                }
                catch (IOException e) {
                    throw new HttpPostRequestEncoder.ErrorDataEncoderException((Throwable)e);
                }
            } else if (data instanceof FileUpload) {
                FileUpload fileUpload = (FileUpload)data;
                String key = this.encodeAttribute(fileUpload.getName(), this.charset);
                String value = this.encodeAttribute(fileUpload.getFilename(), this.charset);
                Attribute newattribute = this.factory.createAttribute(this.request, key, value);
                this.multipartHttpDatas.add((InterfaceHttpData)newattribute);
                this.globalBodySize += (long)(newattribute.getName().length() + 1) + newattribute.length() + 1L;
            }
            return;
        }
        if (data instanceof Attribute) {
            InternalAttribute internal;
            if (this.duringMixedMode) {
                internal = new InternalAttribute(this.charset);
                internal.addValue("\r\n--" + this.multipartMixedBoundary + "--");
                this.multipartHttpDatas.add(internal);
                this.multipartMixedBoundary = null;
                this.currentFileUpload = null;
                this.duringMixedMode = false;
            }
            internal = new InternalAttribute(this.charset);
            if (!this.multipartHttpDatas.isEmpty()) {
                internal.addValue("\r\n");
            }
            internal.addValue("--" + this.multipartDataBoundary + "\r\n");
            Attribute attribute = (Attribute)data;
            internal.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + attribute.getName() + "\"\r\n");
            internal.addValue(HttpHeaderNames.CONTENT_LENGTH + ": " + attribute.length() + "\r\n");
            Charset localcharset = attribute.getCharset();
            if (localcharset != null) {
                internal.addValue(HttpHeaderNames.CONTENT_TYPE + ": " + DEFAULT_TEXT_CONTENT_TYPE + "; " + HttpHeaderValues.CHARSET + '=' + localcharset.name() + "\r\n");
            }
            internal.addValue("\r\n");
            this.multipartHttpDatas.add(internal);
            this.multipartHttpDatas.add(data);
            this.globalBodySize += attribute.length() + (long)internal.size();
        } else if (data instanceof FileUpload) {
            boolean localMixed;
            FileUpload fileUpload = (FileUpload)data;
            InternalAttribute internal = new InternalAttribute(this.charset);
            if (!this.multipartHttpDatas.isEmpty()) {
                internal.addValue("\r\n");
            }
            if (this.duringMixedMode) {
                if (this.currentFileUpload != null && this.currentFileUpload.getName().equals(fileUpload.getName())) {
                    localMixed = true;
                } else {
                    internal.addValue("--" + this.multipartMixedBoundary + "--");
                    this.multipartHttpDatas.add(internal);
                    this.multipartMixedBoundary = null;
                    internal = new InternalAttribute(this.charset);
                    internal.addValue("\r\n");
                    localMixed = false;
                    this.currentFileUpload = fileUpload;
                    this.duringMixedMode = false;
                }
            } else if (this.encoderMode != HttpPostRequestEncoder.EncoderMode.HTML5 && this.currentFileUpload != null && this.currentFileUpload.getName().equals(fileUpload.getName())) {
                this.initMixedMultipart();
                InternalAttribute pastAttribute = (InternalAttribute)this.multipartHttpDatas.get(this.multipartHttpDatas.size() - 2);
                this.globalBodySize -= (long)pastAttribute.size();
                StringBuilder replacement = new StringBuilder(139 + this.multipartDataBoundary.length() + this.multipartMixedBoundary.length() * 2 + fileUpload.getFilename().length() + fileUpload.getName().length()).append("--").append(this.multipartDataBoundary).append("\r\n").append((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION).append(": ").append((CharSequence)HttpHeaderValues.FORM_DATA).append("; ").append((CharSequence)HttpHeaderValues.NAME).append("=\"").append(fileUpload.getName()).append("\"\r\n").append((CharSequence)HttpHeaderNames.CONTENT_TYPE).append(": ").append((CharSequence)HttpHeaderValues.MULTIPART_MIXED).append("; ").append((CharSequence)HttpHeaderValues.BOUNDARY).append('=').append(this.multipartMixedBoundary).append("\r\n\r\n").append("--").append(this.multipartMixedBoundary).append("\r\n").append((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION).append(": ").append((CharSequence)HttpHeaderValues.ATTACHMENT).append("; ");
                if (!fileUpload.getFilename().isEmpty()) {
                    replacement.append((CharSequence)HttpHeaderValues.FILENAME).append("=\"").append(fileUpload.getFilename());
                }
                replacement.append("\"\r\n");
                pastAttribute.setValue(replacement.toString(), 1);
                pastAttribute.setValue("", 2);
                this.globalBodySize += (long)pastAttribute.size();
                localMixed = true;
                this.duringMixedMode = true;
            } else {
                localMixed = false;
                this.currentFileUpload = fileUpload;
                this.duringMixedMode = false;
            }
            if (localMixed) {
                internal.addValue("--" + this.multipartMixedBoundary + "\r\n");
                if (!fileUpload.getFilename().isEmpty()) {
                    internal.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.ATTACHMENT + "; " + HttpHeaderValues.FILENAME + "=\"" + fileUpload.getFilename() + "\"\r\n");
                } else {
                    internal.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.ATTACHMENT + ";\r\n");
                }
            } else {
                internal.addValue("--" + this.multipartDataBoundary + "\r\n");
                if (!fileUpload.getFilename().isEmpty()) {
                    internal.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + fileUpload.getName() + "\"; " + HttpHeaderValues.FILENAME + "=\"" + fileUpload.getFilename() + "\"\r\n");
                } else {
                    internal.addValue(HttpHeaderNames.CONTENT_DISPOSITION + ": " + HttpHeaderValues.FORM_DATA + "; " + HttpHeaderValues.NAME + "=\"" + fileUpload.getName() + "\";\r\n");
                }
            }
            internal.addValue(HttpHeaderNames.CONTENT_LENGTH + ": " + fileUpload.length() + "\r\n");
            internal.addValue(HttpHeaderNames.CONTENT_TYPE + ": " + fileUpload.getContentType());
            String contentTransferEncoding = fileUpload.getContentTransferEncoding();
            if (contentTransferEncoding != null && contentTransferEncoding.equals(DEFAULT_TRANSFER_ENCODING)) {
                internal.addValue("\r\n" + HttpHeaderNames.CONTENT_TRANSFER_ENCODING + ": " + DEFAULT_BINARY_CONTENT_TYPE + "\r\n\r\n");
            } else if (fileUpload.getCharset() != null) {
                internal.addValue("; " + HttpHeaderValues.CHARSET + '=' + fileUpload.getCharset().name() + "\r\n\r\n");
            } else {
                internal.addValue("\r\n\r\n");
            }
            this.multipartHttpDatas.add(internal);
            this.multipartHttpDatas.add(data);
            this.globalBodySize += fileUpload.length() + (long)internal.size();
        }
    }

    void cleanFiles() {
        this.factory.cleanRequestHttpData(this.request);
    }

    String encodeAttribute(String s, Charset charset) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        if (s == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(s, charset.name());
            if (this.encoderMode == HttpPostRequestEncoder.EncoderMode.RFC3986) {
                for (Map.Entry<Pattern, String> entry : percentEncodings.entrySet()) {
                    String replacement = entry.getValue();
                    encoded = entry.getKey().matcher(encoded).replaceAll(replacement);
                }
            }
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpPostRequestEncoder.ErrorDataEncoderException(charset.name(), (Throwable)e);
        }
    }

    HttpContent encodeNextChunkMultipart(int sizeleft) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        ByteBuf buffer;
        if (this.currentData == null) {
            return null;
        }
        if (this.currentData instanceof InternalAttribute) {
            buffer = ((InternalAttribute)this.currentData).toByteBuf();
            this.currentData = null;
        } else {
            if (this.currentData instanceof Attribute) {
                try {
                    buffer = ((Attribute)this.currentData).getChunk(sizeleft);
                }
                catch (IOException e) {
                    throw new HttpPostRequestEncoder.ErrorDataEncoderException((Throwable)e);
                }
            }
            try {
                buffer = ((HttpData)this.currentData).getChunk(sizeleft);
            }
            catch (IOException e) {
                throw new HttpPostRequestEncoder.ErrorDataEncoderException((Throwable)e);
            }
            if (buffer.capacity() == 0) {
                this.currentData = null;
                return null;
            }
        }
        this.currentBuffer = this.currentBuffer == null ? buffer : Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, buffer});
        if (this.currentBuffer.readableBytes() < 8096) {
            this.currentData = null;
            return null;
        }
        buffer = this.fillByteBuf();
        return new DefaultHttpContent(buffer);
    }

    @Override
    public HttpClientRequest.Form attr(String name, String value) {
        try {
            this.addBodyAttribute(name, value);
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return this;
    }

    @Override
    public HttpClientRequest.Form charset(Charset charset) {
        this.newCharset = Objects.requireNonNull(charset, "charset");
        this.needNewEncoder = true;
        return this;
    }

    @Override
    public HttpClientRequest.Form cleanOnTerminate(boolean clean) {
        this.cleanOnTerminate = clean;
        return this;
    }

    @Override
    public HttpClientRequest.Form file(String name, File file) {
        this.file(name, file, null);
        return this;
    }

    @Override
    public HttpClientRequest.Form file(String name, InputStream inputStream) {
        this.file(name, inputStream, null);
        return this;
    }

    @Override
    public HttpClientRequest.Form file(String name, String filename, File file, String contentType) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(file, "file");
        Objects.requireNonNull(filename, "filename");
        String scontentType = contentType;
        if (contentType == null) {
            scontentType = DEFAULT_BINARY_CONTENT_TYPE;
        }
        FileUpload fileUpload = this.factory.createFileUpload(this.request, name, filename, scontentType, DEFAULT_TRANSFER_ENCODING, null, file.length());
        try {
            fileUpload.setContent(file);
            this.addBodyHttpData((InterfaceHttpData)fileUpload);
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)new HttpPostRequestEncoder.ErrorDataEncoderException((Throwable)e));
        }
        return this;
    }

    @Override
    public HttpClientRequest.Form file(String name, String filename, InputStream stream, String contentType) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(stream, "stream");
        try {
            String scontentType = contentType;
            if (contentType == null) {
                scontentType = DEFAULT_BINARY_CONTENT_TYPE;
            }
            MemoryFileUpload fileUpload = new MemoryFileUpload(name, filename, scontentType, DEFAULT_TRANSFER_ENCODING, this.charset, -1L);
            fileUpload.setMaxSize(-1L);
            fileUpload.setContent(stream);
            this.addBodyHttpData((InterfaceHttpData)fileUpload);
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)new HttpPostRequestEncoder.ErrorDataEncoderException((Throwable)e));
        }
        return this;
    }

    @Override
    public HttpClientRequest.Form files(String name, File[] files, String[] contentTypes) {
        for (int i = 0; i < files.length; ++i) {
            this.file(name, files[i], contentTypes[i]);
        }
        return this;
    }

    @Override
    public HttpClientRequest.Form files(String name, File[] files, String[] contentTypes, boolean[] textFiles) {
        try {
            this.addBodyFileUploads(name, files, contentTypes, textFiles);
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return this;
    }

    @Override
    public HttpClientRequest.Form encoding(HttpPostRequestEncoder.EncoderMode mode) {
        this.newMode = Objects.requireNonNull(mode, "mode");
        this.needNewEncoder = true;
        return this;
    }

    @Override
    public HttpClientRequest.Form multipart(boolean isMultipart) {
        this.newMultipart = isMultipart;
        this.needNewEncoder = this.isMultipart != isMultipart;
        return this;
    }

    @Override
    public HttpClientRequest.Form textFile(String name, File file) {
        this.textFile(name, file, null);
        return this;
    }

    @Override
    public HttpClientRequest.Form textFile(String name, File file, String contentType) {
        try {
            this.addBodyFileUpload(name, file, contentType, true);
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        return this;
    }

    @Override
    public HttpClientRequest.Form textFile(String name, InputStream stream) {
        this.textFile(name, stream, null);
        return this;
    }

    @Override
    public HttpClientRequest.Form textFile(String name, InputStream stream, String contentType) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(stream, "stream");
        try {
            String scontentType = contentType;
            if (contentType == null) {
                scontentType = DEFAULT_TEXT_CONTENT_TYPE;
            }
            MemoryFileUpload fileUpload = new MemoryFileUpload(name, "", scontentType, null, this.charset, -1L);
            fileUpload.setMaxSize(-1L);
            fileUpload.setContent(stream);
            this.addBodyHttpData((InterfaceHttpData)fileUpload);
        }
        catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)new HttpPostRequestEncoder.ErrorDataEncoderException((Throwable)e));
        }
        return this;
    }

    @Override
    public void run() {
        this.cleanFiles();
    }

    final HttpClientFormEncoder applyChanges(HttpRequest request) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        if (!this.needNewEncoder) {
            return this;
        }
        HttpClientFormEncoder encoder = new HttpClientFormEncoder(this.factory, request, this.newMultipart, this.newCharset, this.newMode);
        encoder.setBodyHttpDatas(this.getBodyListAttributes());
        return encoder;
    }

    HttpContent encodeNextChunkUrlEncoded(int sizeleft) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        ByteBuf buffer;
        if (this.currentData == null) {
            return null;
        }
        int size = sizeleft;
        if (this.isKey) {
            String key = this.currentData.getName();
            buffer = Unpooled.wrappedBuffer((byte[])key.getBytes());
            this.isKey = false;
            if (this.currentBuffer == null) {
                this.currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{buffer, Unpooled.wrappedBuffer((byte[])"=".getBytes())});
                size -= buffer.readableBytes() + 1;
            } else {
                this.currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, buffer, Unpooled.wrappedBuffer((byte[])"=".getBytes())});
                size -= buffer.readableBytes() + 1;
            }
            if (this.currentBuffer.readableBytes() >= 8096) {
                buffer = this.fillByteBuf();
                return new DefaultHttpContent(buffer);
            }
        }
        try {
            buffer = ((HttpData)this.currentData).getChunk(size);
        }
        catch (IOException e) {
            throw new HttpPostRequestEncoder.ErrorDataEncoderException((Throwable)e);
        }
        ByteBuf delimiter = null;
        if (buffer.readableBytes() < size) {
            this.isKey = true;
            ByteBuf byteBuf = delimiter = this.iterator.hasNext() ? Unpooled.wrappedBuffer((byte[])"&".getBytes()) : null;
        }
        if (buffer.capacity() == 0) {
            this.currentData = null;
            this.currentBuffer = this.currentBuffer == null ? delimiter : (delimiter != null ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, delimiter}) : Unpooled.wrappedBuffer((ByteBuf)this.currentBuffer));
            if (this.currentBuffer.readableBytes() >= 8096) {
                buffer = this.fillByteBuf();
                return new DefaultHttpContent(buffer);
            }
            return null;
        }
        this.currentBuffer = this.currentBuffer == null ? (delimiter != null ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{buffer, delimiter}) : buffer) : (delimiter != null ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, buffer, delimiter}) : Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.currentBuffer, buffer}));
        if (this.currentBuffer.readableBytes() < 8096) {
            this.currentData = null;
            this.isKey = true;
            return null;
        }
        buffer = this.fillByteBuf();
        return new DefaultHttpContent(buffer);
    }

    ByteBuf fillByteBuf() {
        int length = this.currentBuffer.readableBytes();
        if (length > 8096) {
            ByteBuf slice = this.currentBuffer.slice(this.currentBuffer.readerIndex(), 8096);
            this.currentBuffer.skipBytes(8096);
            return slice;
        }
        ByteBuf slice = this.currentBuffer;
        this.currentBuffer = null;
        return slice;
    }

    HttpRequest finalizeRequest() throws HttpPostRequestEncoder.ErrorDataEncoderException {
        if (!this.headerFinalized) {
            if (this.isMultipart) {
                InternalAttribute internal = new InternalAttribute(this.charset);
                if (this.duringMixedMode) {
                    internal.addValue("\r\n--" + this.multipartMixedBoundary + "--");
                }
                internal.addValue("\r\n--" + this.multipartDataBoundary + "--\r\n");
                this.multipartHttpDatas.add(internal);
                this.multipartMixedBoundary = null;
                this.currentFileUpload = null;
                this.duringMixedMode = false;
                this.globalBodySize += (long)internal.size();
            }
        } else {
            throw new HttpPostRequestEncoder.ErrorDataEncoderException("Header already encoded");
        }
        this.headerFinalized = true;
        HttpHeaders headers = this.request.headers();
        List contentTypes = headers.getAll((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        List transferEncoding = headers.getAll((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        if (contentTypes != null) {
            headers.remove((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            for (String contentType : contentTypes) {
                String lowercased = contentType.toLowerCase();
                if (lowercased.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString()) || lowercased.startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString())) continue;
                headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
            }
        }
        if (this.isMultipart) {
            String value = HttpHeaderValues.MULTIPART_FORM_DATA + "; " + HttpHeaderValues.BOUNDARY + '=' + this.multipartDataBoundary;
            headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)value);
        } else {
            headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
        }
        long realSize = this.globalBodySize;
        if (this.isMultipart) {
            this.iterator = this.multipartHttpDatas.listIterator();
        } else {
            --realSize;
            this.iterator = this.multipartHttpDatas.listIterator();
        }
        headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(realSize));
        if (realSize > 8096L || this.isMultipart) {
            this.isChunked = true;
            if (transferEncoding != null) {
                headers.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
                for (CharSequence v : transferEncoding) {
                    if (HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase(v)) continue;
                    headers.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)v);
                }
            }
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.request, (boolean)true);
            return new WrappedHttpRequest(this.request);
        }
        HttpContent chunk = this.nextChunk();
        if (this.request instanceof FullHttpRequest) {
            FullHttpRequest fullRequest = (FullHttpRequest)this.request;
            ByteBuf chunkContent = chunk.content();
            if (fullRequest.content() != chunkContent) {
                fullRequest.content().clear().writeBytes(chunkContent);
                chunkContent.release();
            }
            return fullRequest;
        }
        return new WrappedFullHttpRequest(this.request, chunk);
    }

    List<InterfaceHttpData> getBodyListAttributes() {
        return this.bodyListDatas;
    }

    void initDataMultipart() {
        this.multipartDataBoundary = HttpClientFormEncoder.getNewMultipartDelimiter();
    }

    void initMixedMultipart() {
        this.multipartMixedBoundary = HttpClientFormEncoder.getNewMultipartDelimiter();
    }

    boolean isChunked() {
        return this.isChunked;
    }

    boolean isMultipart() {
        return this.isMultipart;
    }

    HttpContent nextChunk() throws HttpPostRequestEncoder.ErrorDataEncoderException {
        HttpContent chunk;
        if (this.isLastChunk) {
            this.isLastChunkSent = true;
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        int size = 8096;
        if (this.currentBuffer != null) {
            size -= this.currentBuffer.readableBytes();
        }
        if (size <= 0) {
            ByteBuf buffer = this.fillByteBuf();
            return new DefaultHttpContent(buffer);
        }
        if (this.currentData != null) {
            if (this.isMultipart ? (chunk = this.encodeNextChunkMultipart(size)) != null : (chunk = this.encodeNextChunkUrlEncoded(size)) != null) {
                return chunk;
            }
            size = 8096 - this.currentBuffer.readableBytes();
        }
        if (!this.iterator.hasNext()) {
            this.isLastChunk = true;
            ByteBuf buffer = this.currentBuffer;
            this.currentBuffer = null;
            return new DefaultHttpContent(buffer);
        }
        while (size > 0 && this.iterator.hasNext()) {
            this.currentData = this.iterator.next();
            chunk = this.isMultipart ? this.encodeNextChunkMultipart(size) : this.encodeNextChunkUrlEncoded(size);
            if (chunk == null) {
                size = 8096 - this.currentBuffer.readableBytes();
                continue;
            }
            return chunk;
        }
        this.isLastChunk = true;
        if (this.currentBuffer == null) {
            this.isLastChunkSent = true;
            return LastHttpContent.EMPTY_LAST_CONTENT;
        }
        ByteBuf buffer = this.currentBuffer;
        this.currentBuffer = null;
        return new DefaultHttpContent(buffer);
    }

    void setBodyHttpDatas(List<InterfaceHttpData> datas) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        if (datas == null) {
            throw new NullPointerException("datas");
        }
        this.globalBodySize = 0L;
        this.bodyListDatas.clear();
        this.currentFileUpload = null;
        this.duringMixedMode = false;
        this.multipartHttpDatas.clear();
        for (InterfaceHttpData data : datas) {
            this.addBodyHttpData(data);
        }
    }

    static String getNewMultipartDelimiter() {
        return Long.toHexString(ThreadLocalRandom.current().nextLong()).toLowerCase();
    }

    static {
        DiskFileUpload.deleteOnExitTemporaryFile = true;
        DiskFileUpload.baseDirectory = null;
        DiskAttribute.deleteOnExitTemporaryFile = true;
        DiskAttribute.baseDirectory = null;
        percentEncodings.put(Pattern.compile("\\*"), "%2A");
        percentEncodings.put(Pattern.compile("\\+"), "%20");
        percentEncodings.put(Pattern.compile("%7E"), "~");
    }

    static final class InternalAttribute
    extends AbstractReferenceCounted
    implements InterfaceHttpData {
        final List<ByteBuf> value = new ArrayList<ByteBuf>();
        final Charset charset;
        int size;

        InternalAttribute(Charset charset) {
            this.charset = charset;
        }

        public int compareTo(InterfaceHttpData o) {
            if (!(o instanceof InternalAttribute)) {
                throw new ClassCastException("Cannot compare " + this.getHttpDataType() + " with " + o.getHttpDataType());
            }
            return this.compareTo((InternalAttribute)o);
        }

        public boolean equals(Object o) {
            if (!(o instanceof InternalAttribute)) {
                return false;
            }
            InternalAttribute attribute = (InternalAttribute)((Object)o);
            return this.getName().equalsIgnoreCase(attribute.getName());
        }

        public InterfaceHttpData.HttpDataType getHttpDataType() {
            return InterfaceHttpData.HttpDataType.InternalAttribute;
        }

        public String getName() {
            return "InternalAttribute";
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public InterfaceHttpData retain() {
            for (ByteBuf buf : this.value) {
                buf.retain();
            }
            return this;
        }

        public InterfaceHttpData retain(int increment) {
            for (ByteBuf buf : this.value) {
                buf.retain(increment);
            }
            return this;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            for (ByteBuf elt : this.value) {
                result.append(elt.toString(this.charset));
            }
            return result.toString();
        }

        public InterfaceHttpData touch() {
            for (ByteBuf buf : this.value) {
                buf.touch();
            }
            return this;
        }

        public InterfaceHttpData touch(Object hint) {
            for (ByteBuf buf : this.value) {
                buf.touch(hint);
            }
            return this;
        }

        protected void deallocate() {
        }

        void addValue(String value) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)value, (Charset)this.charset);
            this.value.add(buf);
            this.size += buf.readableBytes();
        }

        void addValue(String value, int rank) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)value, (Charset)this.charset);
            this.value.add(rank, buf);
            this.size += buf.readableBytes();
        }

        int compareTo(InternalAttribute o) {
            return this.getName().compareToIgnoreCase(o.getName());
        }

        void setValue(String value, int rank) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)value, (Charset)this.charset);
            ByteBuf old = this.value.set(rank, buf);
            if (old != null) {
                this.size -= old.readableBytes();
                old.release();
            }
            this.size += buf.readableBytes();
        }

        int size() {
            return this.size;
        }

        ByteBuf toByteBuf() {
            return Unpooled.compositeBuffer().addComponents(this.value).writerIndex(this.size()).readerIndex(0);
        }
    }

    static final class WrappedFullHttpRequest
    extends WrappedHttpRequest
    implements FullHttpRequest {
        final HttpContent content;

        WrappedFullHttpRequest(HttpRequest request, HttpContent content) {
            super(request);
            this.content = content;
        }

        public ByteBuf content() {
            return this.content.content();
        }

        public FullHttpRequest copy() {
            return this.replace(this.content().copy());
        }

        public FullHttpRequest duplicate() {
            return this.replace(this.content().duplicate());
        }

        public int refCnt() {
            return this.content.refCnt();
        }

        public boolean release() {
            return this.content.release();
        }

        public boolean release(int decrement) {
            return this.content.release(decrement);
        }

        public FullHttpRequest replace(ByteBuf content) {
            DefaultFullHttpRequest duplicate = new DefaultFullHttpRequest(this.protocolVersion(), this.method(), this.uri(), content);
            duplicate.headers().set(this.headers());
            duplicate.trailingHeaders().set(this.trailingHeaders());
            return duplicate;
        }

        public FullHttpRequest retain(int increment) {
            this.content.retain(increment);
            return this;
        }

        public FullHttpRequest retain() {
            this.content.retain();
            return this;
        }

        public FullHttpRequest retainedDuplicate() {
            return this.replace(this.content().retainedDuplicate());
        }

        public FullHttpRequest setMethod(HttpMethod method) {
            super.setMethod(method);
            return this;
        }

        public FullHttpRequest setProtocolVersion(HttpVersion version) {
            super.setProtocolVersion(version);
            return this;
        }

        public FullHttpRequest setUri(String uri) {
            super.setUri(uri);
            return this;
        }

        public FullHttpRequest touch() {
            this.content.touch();
            return this;
        }

        public FullHttpRequest touch(Object hint) {
            this.content.touch(hint);
            return this;
        }

        public HttpHeaders trailingHeaders() {
            if (this.content instanceof LastHttpContent) {
                return ((LastHttpContent)this.content).trailingHeaders();
            }
            return EmptyHttpHeaders.INSTANCE;
        }
    }

    static class WrappedHttpRequest
    implements HttpRequest {
        final HttpRequest request;

        public WrappedHttpRequest(HttpRequest request) {
            this.request = request;
        }

        public DecoderResult decoderResult() {
            return this.request.decoderResult();
        }

        @Deprecated
        public DecoderResult getDecoderResult() {
            return this.request.getDecoderResult();
        }

        public void setDecoderResult(DecoderResult result) {
            this.request.setDecoderResult(result);
        }

        public HttpMethod getMethod() {
            return this.request.method();
        }

        public HttpVersion getProtocolVersion() {
            return this.request.protocolVersion();
        }

        public String getUri() {
            return this.request.uri();
        }

        public HttpHeaders headers() {
            return this.request.headers();
        }

        public HttpMethod method() {
            return this.request.method();
        }

        public HttpVersion protocolVersion() {
            return this.request.protocolVersion();
        }

        public HttpRequest setMethod(HttpMethod method) {
            this.request.setMethod(method);
            return this;
        }

        public HttpRequest setProtocolVersion(HttpVersion version) {
            this.request.setProtocolVersion(version);
            return this;
        }

        public HttpRequest setUri(String uri) {
            this.request.setUri(uri);
            return this;
        }

        public String uri() {
            return this.request.uri();
        }
    }
}

