/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpConstants;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.http.Cookies;
import reactor.ipc.netty.http.HttpOperations;
import reactor.ipc.netty.http.client.HttpClientException;
import reactor.ipc.netty.http.client.HttpClientFormEncoder;
import reactor.ipc.netty.http.client.HttpClientRequest;
import reactor.ipc.netty.http.client.HttpClientResponse;
import reactor.ipc.netty.http.client.HttpClientWSOperations;
import reactor.ipc.netty.http.client.RedirectClientException;
import reactor.ipc.netty.http.websocket.WebsocketInbound;
import reactor.ipc.netty.http.websocket.WebsocketOutbound;
import reactor.util.Logger;
import reactor.util.Loggers;

class HttpClientOperations
extends HttpOperations<HttpClientResponse, HttpClientRequest>
implements HttpClientResponse,
HttpClientRequest {
    final String[] redirectedFrom;
    final boolean isSecure;
    final HttpRequest nettyRequest;
    final HttpHeaders requestHeaders;
    volatile ResponseState responseState;
    int inboundPrefetch;
    boolean clientError = true;
    boolean serverError = true;
    boolean redirectable;
    static final int MAX_REDIRECTS = 50;
    static final String[] EMPTY_REDIRECTIONS = new String[0];
    static final Logger log = Loggers.getLogger(HttpClientOperations.class);
    static final AttributeKey<String[]> REDIRECT_ATTR_KEY = AttributeKey.newInstance((String)"httpRedirects");

    static HttpOperations bindHttp(Channel channel, BiFunction<? super HttpClientResponse, ? super HttpClientRequest, ? extends Publisher<Void>> handler, ContextHandler<?> context) {
        return new HttpClientOperations(channel, handler, context);
    }

    HttpClientOperations(Channel channel, HttpClientOperations replaced) {
        super(channel, replaced);
        this.redirectedFrom = replaced.redirectedFrom;
        this.isSecure = replaced.isSecure;
        this.nettyRequest = replaced.nettyRequest;
        this.responseState = replaced.responseState;
        this.redirectable = replaced.redirectable;
        this.inboundPrefetch = replaced.inboundPrefetch;
        this.requestHeaders = replaced.requestHeaders;
    }

    HttpClientOperations(Channel channel, BiFunction<? super HttpClientResponse, ? super HttpClientRequest, ? extends Publisher<Void>> handler, ContextHandler<?> context) {
        super(channel, handler, context);
        this.isSecure = channel.pipeline().get("sslHandler") != null;
        String[] redirects = (String[])channel.attr(REDIRECT_ATTR_KEY).get();
        this.redirectedFrom = redirects == null ? EMPTY_REDIRECTIONS : redirects;
        this.nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        this.requestHeaders = this.nettyRequest.headers();
        this.inboundPrefetch = 16;
        this.chunkedTransfer(true);
    }

    @Override
    public HttpClientRequest addCookie(Cookie cookie) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.add((CharSequence)HttpHeaderNames.COOKIE, (Object)ClientCookieEncoder.STRICT.encode(cookie));
        return this;
    }

    @Override
    public final HttpClientOperations addHandler(ChannelHandler handler) {
        super.addHandler(handler);
        return this;
    }

    @Override
    public final HttpClientOperations addHandler(String name, ChannelHandler handler) {
        super.addHandler(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations addDecoder(ChannelHandler handler) {
        super.addDecoder(handler);
        return this;
    }

    @Override
    public HttpClientOperations addDecoder(String name, ChannelHandler handler) {
        super.addDecoder(name, handler);
        return this;
    }

    @Override
    public HttpClientRequest addHeader(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public InetSocketAddress address() {
        return ((SocketChannel)this.channel()).remoteAddress();
    }

    @Override
    public HttpClientRequest chunkedTransfer(boolean chunked) {
        if (!this.hasSentHeaders() && HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyRequest) != chunked) {
            this.requestHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.nettyRequest, (boolean)chunked);
        }
        return this;
    }

    @Override
    public Map<CharSequence, Set<Cookie>> cookies() {
        ResponseState responseState = this.responseState;
        if (responseState != null) {
            return responseState.cookieHolder.getCachedCookies();
        }
        return null;
    }

    @Override
    public HttpClientRequest followRedirect() {
        this.redirectable = true;
        return this;
    }

    @Override
    public HttpClientRequest failOnClientError(boolean shouldFail) {
        this.clientError = shouldFail;
        return this;
    }

    @Override
    public HttpClientRequest failOnServerError(boolean shouldFail) {
        this.serverError = shouldFail;
        return this;
    }

    @Override
    public HttpClientRequest header(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.set(name, (Object)value);
        return this;
    }

    @Override
    public HttpClientRequest headers(HttpHeaders headers) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        String host = this.requestHeaders.get((CharSequence)HttpHeaderNames.HOST);
        this.requestHeaders.set(headers);
        this.requestHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)host);
        return this;
    }

    @Override
    public boolean isFollowRedirect() {
        return this.redirectable && this.redirectedFrom.length <= 50;
    }

    @Override
    public boolean isKeepAlive() {
        return HttpUtil.isKeepAlive((HttpMessage)this.nettyRequest);
    }

    @Override
    public boolean isWebsocket() {
        return ((ChannelOperations)this.attr(OPERATIONS_KEY).get()).getClass().equals(HttpClientWSOperations.class);
    }

    @Override
    public HttpClientRequest keepAlive(boolean keepAlive) {
        HttpUtil.setKeepAlive((HttpMessage)this.nettyRequest, (boolean)keepAlive);
        return this;
    }

    @Override
    public HttpMethod method() {
        return this.nettyRequest.method();
    }

    @Override
    public final HttpClientOperations onClose(Runnable onClose) {
        super.onClose(onClose);
        return this;
    }

    @Override
    public String[] redirectedFrom() {
        String[] redirectedFrom = this.redirectedFrom;
        String[] dest = new String[redirectedFrom.length];
        System.arraycopy(redirectedFrom, 0, dest, 0, redirectedFrom.length);
        return dest;
    }

    @Override
    public HttpHeaders requestHeaders() {
        return this.nettyRequest.headers();
    }

    @Override
    public HttpHeaders responseHeaders() {
        ResponseState responseState = this.responseState;
        if (responseState != null) {
            return responseState.headers;
        }
        return null;
    }

    @Override
    public Mono<Void> send() {
        if (this.markHeadersAsSent()) {
            HttpMessage request = this.newFullEmptyBodyMessage();
            return FutureMono.deferFuture(() -> this.channel().writeAndFlush((Object)request));
        }
        return Mono.empty();
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> source) {
        if (this.method() == HttpMethod.GET || this.method() == HttpMethod.HEAD) {
            ByteBufAllocator alloc = this.channel().alloc();
            Flux.from(source).doOnNext(ByteBuf::retain).collect(() -> ((ByteBufAllocator)alloc).buffer(), ByteBuf::writeBytes).then(agg -> {
                if (!(this.hasSentHeaders() || HttpUtil.isTransferEncodingChunked((HttpMessage)this.outboundHttpMessage()) || HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage()))) {
                    this.outboundHttpMessage().headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, agg.readableBytes());
                }
                return this.send((Publisher)Mono.just((Object)agg)).then();
            });
        }
        return super.send(source);
    }

    @Override
    public Flux<Long> sendForm(Consumer<HttpClientRequest.Form> formCallback) {
        return new FluxSendForm(this, (HttpDataFactory)new DefaultHttpDataFactory(16384L), formCallback);
    }

    @Override
    public WebsocketOutbound sendWebsocket() {
        final Mono<Void> m = this.withWebsocketSupport(this.websocketUri(), null, HttpClientOperations.noopHandler());
        return new WebsocketOutbound(){

            @Override
            public NettyContext context() {
                return HttpClientOperations.this;
            }

            public Mono<Void> then() {
                return m;
            }
        };
    }

    @Override
    public Mono<Void> receiveWebsocket(String protocols, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        Objects.requireNonNull(websocketHandler, "websocketHandler");
        return this.withWebsocketSupport(this.websocketUri(), protocols, websocketHandler);
    }

    final URI websocketUri() {
        URI uri;
        try {
            String url = this.uri();
            if (url.startsWith("http") || url.startsWith("ws")) {
                uri = new URI(url);
            } else {
                String host = this.requestHeaders().get((CharSequence)HttpHeaderNames.HOST);
                uri = new URI((this.isSecure ? "wss" : "ws") + "://" + host + (url.startsWith("/") ? url : "/" + url));
            }
        }
        catch (URISyntaxException e) {
            throw Exceptions.bubble((Throwable)e);
        }
        return uri;
    }

    @Override
    public WebsocketInbound receiveWebsocket() {
        return null;
    }

    @Override
    public HttpResponseStatus status() {
        ResponseState responseState = this.responseState;
        if (responseState != null) {
            return HttpResponseStatus.valueOf((int)responseState.response.status().code());
        }
        return null;
    }

    @Override
    public final String uri() {
        return this.nettyRequest.uri();
    }

    @Override
    public final HttpVersion version() {
        HttpVersion version = this.nettyRequest.protocolVersion();
        if (version.equals((Object)HttpVersion.HTTP_1_0)) {
            return HttpVersion.HTTP_1_0;
        }
        if (version.equals((Object)HttpVersion.HTTP_1_1)) {
            return HttpVersion.HTTP_1_1;
        }
        throw new IllegalStateException(version.protocolName() + " not supported");
    }

    @Override
    protected void onHandlerStart() {
        this.applyHandler();
    }

    @Override
    protected void onOutboundComplete() {
        if (this.isWebsocket()) {
            return;
        }
        if (this.markHeadersAsSent()) {
            this.channel().writeAndFlush((Object)this.newFullEmptyBodyMessage());
        } else if (HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyRequest)) {
            this.channel().writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        this.channel().read();
    }

    @Override
    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            this.setNettyResponse(response);
            if (response.decoderResult().isFailure()) {
                this.onOutboundError(response.decoderResult().cause());
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Received response (auto-read:{}) : {}", new Object[]{this.channel().config().isAutoRead(), this.responseHeaders().entries().toString()});
            }
            if (this.checkResponseCode(response)) {
                this.prefetchMore(ctx);
                this.parentContext().fireContextActive(this);
            }
            if (msg instanceof FullHttpResponse) {
                super.onInboundNext(ctx, msg);
                this.onHandlerTerminate();
            }
            return;
        }
        if (msg instanceof LastHttpContent) {
            if (log.isDebugEnabled()) {
                log.debug("Received last HTTP packet");
            }
            if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
                super.onInboundNext(ctx, msg);
            }
            this.onHandlerTerminate();
            return;
        }
        super.onInboundNext(ctx, msg);
        if (this.isInboundCancelled()) {
            ctx.read();
        } else {
            this.prefetchMore(ctx);
        }
    }

    @Override
    protected HttpMessage outboundHttpMessage() {
        return this.nettyRequest;
    }

    final boolean checkResponseCode(HttpResponse response) {
        int code = response.status().code();
        if (code >= 500 && this.serverError) {
            if (log.isDebugEnabled()) {
                log.debug("Received Server Error, stop reading: {}", new Object[]{response.toString()});
            }
            HttpClientException ex = new HttpClientException(this.uri(), response);
            this.parentContext().fireContextError(ex);
            this.onHandlerTerminate();
            return false;
        }
        if (code >= 400 && this.clientError) {
            if (log.isDebugEnabled()) {
                log.debug("Received Request Error, stop reading: {}", new Object[]{response.toString()});
            }
            HttpClientException ex = new HttpClientException(this.uri(), response);
            this.parentContext().fireContextError(ex);
            this.onHandlerTerminate();
            return false;
        }
        if (code == 301 || code == 302 && this.isFollowRedirect()) {
            if (log.isDebugEnabled()) {
                log.debug("Received Redirect location: {}", new Object[]{response.headers().entries().toString()});
            }
            RedirectClientException ex = new RedirectClientException(this.uri(), response);
            this.parentContext().fireContextError(ex);
            this.onHandlerTerminate();
            return false;
        }
        return true;
    }

    @Override
    protected HttpMessage newFullEmptyBodyMessage() {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(this.version(), this.method(), this.uri());
        request.headers().set(this.requestHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING).setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0));
        return request;
    }

    final HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    final void prefetchMore(ChannelHandlerContext ctx) {
        int inboundPrefetch = this.inboundPrefetch - 1;
        if (inboundPrefetch >= 0) {
            this.inboundPrefetch = inboundPrefetch;
            ctx.read();
        }
    }

    final void setNettyResponse(HttpResponse nettyResponse) {
        ResponseState state = this.responseState;
        if (state == null) {
            this.responseState = new ResponseState(nettyResponse, nettyResponse.headers());
        }
    }

    final Mono<Void> withWebsocketSupport(URI url, String protocols, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        if (this.markHeadersAsSent()) {
            this.addHandler("reactorHttpAggregator", (ChannelHandler)new HttpObjectAggregator(8192));
            HttpClientWSOperations ops = new HttpClientWSOperations(url, protocols, this);
            if (this.replace(ops)) {
                Mono handshake = FutureMono.from(ops.handshakerResult).then(() -> Mono.from((Publisher)((Publisher)websocketHandler.apply(ops, ops))));
                if (websocketHandler != HttpClientOperations.noopHandler()) {
                    handshake = handshake.doAfterTerminate((BiConsumer)ops);
                }
                return handshake;
            }
        } else {
            if (this.isWebsocket()) {
                HttpClientWSOperations ops = (HttpClientWSOperations)this.attr(OPERATIONS_KEY).get();
                Mono handshake = FutureMono.from(ops.handshakerResult);
                if (websocketHandler != HttpClientOperations.noopHandler()) {
                    handshake = handshake.then(() -> Mono.from((Publisher)((Publisher)websocketHandler.apply(ops, ops)))).doAfterTerminate((BiConsumer)ops);
                }
                return handshake;
            }
            log.error("Cannot enable websocket if headers have already been sent");
        }
        return Mono.error((Throwable)new IllegalStateException("Failed to upgrade to websocket"));
    }

    static final class FluxSendForm
    extends Flux<Long> {
        final HttpClientOperations parent;
        final Consumer<HttpClientRequest.Form> formCallback;
        final HttpDataFactory df;

        FluxSendForm(HttpClientOperations parent, HttpDataFactory df, Consumer<HttpClientRequest.Form> formCallback) {
            this.parent = parent;
            this.df = df;
            this.formCallback = formCallback;
        }

        public void subscribe(Subscriber<? super Long> s) {
            if (s == null) {
                throw Exceptions.argumentIsNullException();
            }
            if (this.parent.channel().eventLoop().inEventLoop()) {
                this._subscribe(s);
            } else {
                this.parent.channel().eventLoop().execute(() -> this._subscribe(s));
            }
        }

        void _subscribe(Subscriber<? super Long> s) {
            if (!this.parent.markHeadersAsSent()) {
                Operators.error(s, (Throwable)new IllegalStateException("headers have already been sent"));
                return;
            }
            try {
                HttpClientFormEncoder encoder = new HttpClientFormEncoder(this.df, this.parent.nettyRequest, false, HttpConstants.DEFAULT_CHARSET, HttpPostRequestEncoder.EncoderMode.RFC1738);
                this.formCallback.accept(encoder);
                encoder = encoder.applyChanges(this.parent.nettyRequest);
                if (!encoder.isMultipart) {
                    this.parent.chunkedTransfer(false);
                }
                this.parent.addHandler("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                boolean chunked = HttpUtil.isTransferEncodingChunked((HttpMessage)this.parent.nettyRequest);
                HttpRequest r = encoder.finalizeRequest();
                if (!chunked) {
                    HttpUtil.setTransferEncodingChunked((HttpMessage)r, (boolean)false);
                    HttpUtil.setContentLength((HttpMessage)r, (long)encoder.length());
                }
                ChannelFuture f = this.parent.channel().writeAndFlush((Object)r);
                Flux tail = encoder.progressFlux.onBackpressureLatest();
                if (encoder.cleanOnTerminate) {
                    tail = tail.doOnCancel((Runnable)encoder).doAfterTerminate((Runnable)encoder);
                }
                if (encoder.isChunked()) {
                    tail.subscribe(s);
                    this.parent.channel().writeAndFlush((Object)encoder);
                } else {
                    FutureMono.from(f).cast(Long.class).otherwiseIfEmpty(Mono.just((Object)encoder.length())).flux().subscribe(s);
                }
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.df.cleanRequestHttpData(this.parent.nettyRequest);
                Operators.error(s, (Throwable)Exceptions.unwrap((Throwable)e));
            }
        }
    }

    static final class ResponseState {
        final HttpResponse response;
        final HttpHeaders headers;
        final Cookies cookieHolder;

        ResponseState(HttpResponse response, HttpHeaders headers) {
            this.response = response;
            this.headers = headers;
            this.cookieHolder = Cookies.newClientResponseHolder(headers);
        }
    }
}

