/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.server;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Queue;
import reactor.core.Exceptions;
import reactor.ipc.netty.NettyPipeline;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.http.server.HttpServerOperations;
import reactor.util.concurrent.QueueSupplier;

final class HttpServerHandler
extends ChannelDuplexHandler
implements Runnable {
    static final String MULTIPART_PREFIX = "multipart";
    final ContextHandler<?> parentContext;
    boolean persistentConnection = true;
    int pendingResponses;
    Queue<Object> pipelined;
    ChannelHandlerContext ctx;
    boolean overflow;
    boolean mustRecycleEncoder;

    HttpServerHandler(ContextHandler<?> parentContext) {
        this.parentContext = parentContext;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
        if (HttpServerOperations.log.isDebugEnabled()) {
            HttpServerOperations.log.debug("New http connection, requesting read");
        }
        ctx.read();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)msg;
            if (this.persistentConnection) {
                ++this.pendingResponses;
            } else {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug("dropping pipelined HTTP request, previous response requested connection close");
                }
                ReferenceCountUtil.release((Object)msg);
                return;
            }
            this.persistentConnection = HttpUtil.isKeepAlive((HttpMessage)request);
            if (this.overflow || this.pendingResponses > 1) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug("buffering pipelined HTTP request, pending response count: {}, queue: {}", new Object[]{this.pendingResponses, this.pipelined != null ? this.pipelined.size() : 0});
                }
                this.overflow = true;
                this.doPipeline(ctx, msg);
                return;
            }
            this.overflow = false;
            this.parentContext.createOperations(ctx.channel(), msg);
            if (!(msg instanceof FullHttpRequest)) {
                return;
            }
        } else if (this.overflow) {
            if (HttpServerOperations.log.isDebugEnabled()) {
                HttpServerOperations.log.debug("buffering pipelined HTTP content, pending response count: {}, pending pipeline:{}", new Object[]{this.pendingResponses, this.pipelined != null ? this.pipelined.size() : 0});
            }
            this.doPipeline(ctx, msg);
            return;
        }
        ctx.fireChannelRead(msg);
    }

    void doPipeline(ChannelHandlerContext ctx, Object msg) {
        if (this.pipelined == null) {
            this.pipelined = (Queue)QueueSupplier.unbounded().get();
        }
        if (!this.pipelined.offer(msg)) {
            ctx.fireExceptionCaught((Throwable)Exceptions.failWithOverflow());
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            this.trackResponse(response);
            if (!HttpUtil.isKeepAlive((HttpMessage)response) || !HttpServerHandler.isSelfDefinedMessageLength(response)) {
                this.pendingResponses = 0;
                this.persistentConnection = false;
            }
            if (!this.shouldKeepAlive()) {
                HttpUtil.setKeepAlive((HttpMessage)response, (boolean)false);
            }
        }
        if (msg instanceof LastHttpContent) {
            if (!this.shouldKeepAlive()) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug("Detected non persistent http connection, preparing to close", new Object[]{this.pendingResponses});
                }
                promise.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else if (this.mustRecycleEncoder) {
                this.mustRecycleEncoder = false;
                --this.pendingResponses;
            }
        }
        ctx.write(msg, promise);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == NettyPipeline.handlerTerminatedEvent()) {
            if (this.mustRecycleEncoder) {
                this.mustRecycleEncoder = false;
                --this.pendingResponses;
                ctx.pipeline().replace("httpEncoder", "httpEncoder", (ChannelHandler)new HttpResponseEncoder());
            }
            if (this.pipelined != null && !this.pipelined.isEmpty()) {
                if (HttpServerOperations.log.isDebugEnabled()) {
                    HttpServerOperations.log.debug("draining next pipelined request, pending response count: {}, queued: {}", new Object[]{this.pendingResponses, this.pipelined.size()});
                }
                ctx.executor().execute((Runnable)this);
            } else {
                ctx.read();
            }
        }
        ctx.fireUserEventTriggered(evt);
    }

    void trackResponse(HttpResponse response) {
        this.mustRecycleEncoder = !HttpServerHandler.isInformational(response);
    }

    @Override
    public void run() {
        Object next;
        boolean nextRequest = false;
        while ((next = this.pipelined.peek()) != null) {
            if (next instanceof HttpRequest) {
                if (nextRequest || !this.persistentConnection) {
                    return;
                }
                nextRequest = true;
                this.parentContext.createOperations(this.ctx.channel(), next);
                if (!(next instanceof FullHttpRequest)) {
                    this.pipelined.poll();
                    continue;
                }
            }
            this.ctx.fireChannelRead(this.pipelined.poll());
        }
        this.overflow = false;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.discard();
    }

    final void discard() {
        if (this.pipelined != null && !this.pipelined.isEmpty()) {
            Object o;
            while ((o = this.pipelined.poll()) != null) {
                ReferenceCountUtil.release((Object)o);
            }
        }
    }

    boolean shouldKeepAlive() {
        return this.pendingResponses != 0 || this.persistentConnection;
    }

    static boolean isSelfDefinedMessageLength(HttpResponse response) {
        return HttpUtil.isContentLengthSet((HttpMessage)response) || HttpUtil.isTransferEncodingChunked((HttpMessage)response) || HttpServerHandler.isMultipart(response) || HttpServerHandler.isInformational(response);
    }

    static boolean isInformational(HttpResponse response) {
        return response.status().codeClass() == HttpStatusClass.INFORMATIONAL;
    }

    static boolean isMultipart(HttpResponse response) {
        String contentType = response.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        return contentType != null && contentType.regionMatches(true, 0, MULTIPART_PREFIX, 0, MULTIPART_PREFIX.length());
    }
}

