/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.resources;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.ThreadFactory;
import reactor.ipc.netty.resources.ColocatedEventLoopGroup;
import reactor.util.Logger;
import reactor.util.Loggers;

final class DefaultLoopEpollDetector {
    static final Logger log = Loggers.getLogger(DefaultLoopEpollDetector.class);
    private static final boolean epoll;

    DefaultLoopEpollDetector() {
    }

    public static EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory) {
        if (epoll) {
            return new EpollEventLoopGroup(threads, factory);
        }
        throw new IllegalStateException("Missing EPoll on current system");
    }

    public static Class<? extends ServerChannel> getServerChannel(EventLoopGroup group) {
        return DefaultLoopEpollDetector.useEpoll(group) ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    public static Class<? extends Channel> getChannel(EventLoopGroup group) {
        return DefaultLoopEpollDetector.useEpoll(group) ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    public static Class<? extends DatagramChannel> getDatagramChannel(EventLoopGroup group) {
        return DefaultLoopEpollDetector.useEpoll(group) ? EpollDatagramChannel.class : NioDatagramChannel.class;
    }

    public static boolean hasEpoll() {
        return epoll;
    }

    private static boolean useEpoll(EventLoopGroup group) {
        if (!epoll) {
            return false;
        }
        if (group instanceof ColocatedEventLoopGroup) {
            group = ((ColocatedEventLoopGroup)group).getEventLoopGroup();
        }
        return group instanceof EpollEventLoopGroup;
    }

    static {
        boolean epollCheck = false;
        try {
            Class.forName("io.netty.channel.epoll.Epoll");
            epollCheck = Epoll.isAvailable();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        epoll = epollCheck;
        if (log.isDebugEnabled()) {
            log.debug("Default epoll support : " + epoll);
        }
    }
}

