/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.resources;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.net.SocketAddress;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import reactor.ipc.netty.resources.PoolResources;
import reactor.util.Logger;
import reactor.util.Loggers;

final class DefaultPoolResources
implements PoolResources {
    final ConcurrentMap<SocketAddress, Pool> channelPools;
    final String name;
    final BiFunction<Bootstrap, ChannelPoolHandler, ChannelPool> provider;
    static final Logger log = Loggers.getLogger(DefaultPoolResources.class);

    DefaultPoolResources(String name, BiFunction<Bootstrap, ChannelPoolHandler, ChannelPool> provider) {
        this.name = name;
        this.provider = provider;
        this.channelPools = PlatformDependent.newConcurrentHashMap();
    }

    @Override
    public ChannelPool selectOrCreate(SocketAddress remote, Supplier<? extends Bootstrap> bootstrap) {
        SocketAddress address = remote;
        Pool pool;
        while ((pool = (Pool)this.channelPools.get(remote)) == null) {
            Bootstrap b = bootstrap.get();
            if (remote != null) {
                b = b.remoteAddress(remote);
            } else {
                address = b.config().remoteAddress();
            }
            if (log.isDebugEnabled()) {
                log.debug("New {} client pool for {}", new Object[]{this.name, address});
            }
            if (this.channelPools.putIfAbsent(address, pool = new Pool(b, this.provider)) == null) {
                return pool;
            }
            pool.close();
        }
        return pool;
    }

    @Override
    public void dispose() {
        for (SocketAddress key : this.channelPools.keySet()) {
            Pool pool = (Pool)this.channelPools.remove(key);
            if (pool == null) continue;
            pool.close();
        }
    }

    static final class Pool
    extends AtomicBoolean
    implements ChannelPoolHandler,
    ChannelPool {
        final ChannelPool pool;
        int activeConnections;

        Pool(Bootstrap bootstrap, BiFunction<Bootstrap, ChannelPoolHandler, ChannelPool> provider) {
            this.pool = provider.apply(bootstrap, this);
        }

        public Future<Channel> acquire() {
            return this.pool.acquire();
        }

        public Future<Channel> acquire(Promise<Channel> promise) {
            return this.pool.acquire(promise);
        }

        public Future<Void> release(Channel channel) {
            return this.pool.release(channel);
        }

        public Future<Void> release(Channel channel, Promise<Void> promise) {
            return this.pool.release(channel, promise);
        }

        public void close() {
            if (this.compareAndSet(false, true)) {
                this.pool.close();
            }
        }

        public void channelReleased(Channel ch) throws Exception {
            --this.activeConnections;
            if (log.isDebugEnabled()) {
                log.debug("Released {}, now {} active connections", new Object[]{ch.toString(), this.activeConnections});
            }
        }

        public void channelAcquired(Channel ch) throws Exception {
            ++this.activeConnections;
            if (log.isDebugEnabled()) {
                log.debug("Acquired {}, now {} active connections", new Object[]{ch.toString(), this.activeConnections});
            }
        }

        public void channelCreated(Channel ch) throws Exception {
            ++this.activeConnections;
            if (log.isDebugEnabled()) {
                log.debug("Created {}, now {} active connections", new Object[]{ch.toString(), this.activeConnections});
            }
        }

        @Override
        public String toString() {
            return this.pool.getClass().getSimpleName() + "{activeConnections=" + this.activeConnections + '}';
        }
    }
}

