/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.socket.DatagramChannel;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import reactor.ipc.netty.resources.LoopResources;
import reactor.ipc.netty.resources.PoolResources;

public class TcpResources
implements PoolResources,
LoopResources {
    final PoolResources defaultPools;
    final LoopResources defaultLoops;
    static final AtomicReference<TcpResources> tcpResources;
    static final BiFunction<LoopResources, PoolResources, TcpResources> ON_TCP_NEW;

    public static TcpResources get() {
        return TcpResources.getOrCreate(tcpResources, null, null, ON_TCP_NEW, "tcp");
    }

    public static TcpResources set(PoolResources pools) {
        return TcpResources.getOrCreate(tcpResources, null, pools, ON_TCP_NEW, "tcp");
    }

    public static TcpResources set(LoopResources loops) {
        return TcpResources.getOrCreate(tcpResources, loops, null, ON_TCP_NEW, "tcp");
    }

    public static TcpResources reset() {
        TcpResources resources = tcpResources.getAndSet(null);
        if (resources != null) {
            resources._dispose();
        }
        return TcpResources.getOrCreate(tcpResources, null, null, ON_TCP_NEW, "tcp");
    }

    protected TcpResources(LoopResources defaultLoops, PoolResources defaultPools) {
        this.defaultLoops = defaultLoops;
        this.defaultPools = defaultPools;
    }

    @Override
    public void dispose() {
    }

    protected void _dispose() {
        this.defaultPools.dispose();
        this.defaultLoops.dispose();
    }

    @Override
    public ChannelPool selectOrCreate(SocketAddress address, Supplier<? extends Bootstrap> bootstrap) {
        return this.defaultPools.selectOrCreate(address, bootstrap);
    }

    @Override
    public Class<? extends Channel> onChannel(EventLoopGroup group) {
        return this.defaultLoops.onChannel(group);
    }

    @Override
    public EventLoopGroup onClient(boolean useNative) {
        return this.defaultLoops.onClient(useNative);
    }

    @Override
    public Class<? extends DatagramChannel> onDatagramChannel(EventLoopGroup group) {
        return this.defaultLoops.onDatagramChannel(group);
    }

    @Override
    public EventLoopGroup onServer(boolean useNative) {
        return this.defaultLoops.onServer(useNative);
    }

    @Override
    public Class<? extends ServerChannel> onServerChannel(EventLoopGroup group) {
        return this.defaultLoops.onServerChannel(group);
    }

    @Override
    public EventLoopGroup onServerSelect(boolean useNative) {
        return this.defaultLoops.onServerSelect(useNative);
    }

    @Override
    public boolean preferNative() {
        return this.defaultLoops.preferNative();
    }

    @Override
    public boolean daemon() {
        return this.defaultLoops.daemon();
    }

    protected static <T extends TcpResources> T getOrCreate(AtomicReference<T> ref, LoopResources loops, PoolResources pools, BiFunction<LoopResources, PoolResources, T> onNew, String name) {
        TcpResources resources;
        while ((resources = (TcpResources)ref.get()) == null || loops != null || pools != null) {
            TcpResources update = TcpResources.create(resources, loops, pools, name, onNew);
            if (ref.compareAndSet(resources, update)) {
                if (resources != null) {
                    if (loops != null) {
                        resources.defaultLoops.dispose();
                    }
                    if (pools != null) {
                        resources.defaultPools.dispose();
                    }
                }
                return (T)update;
            }
            update._dispose();
        }
        return (T)resources;
    }

    static <T extends TcpResources> T create(T previous, LoopResources loops, PoolResources pools, String name, BiFunction<LoopResources, PoolResources, T> onNew) {
        if (previous == null) {
            loops = loops == null ? LoopResources.create("reactor-" + name) : loops;
            pools = pools == null ? PoolResources.fixed(name) : pools;
        } else {
            loops = loops == null ? previous.defaultLoops : loops;
            pools = pools == null ? previous.defaultPools : pools;
        }
        return (T)((TcpResources)onNew.apply(loops, pools));
    }

    static {
        ON_TCP_NEW = TcpResources::new;
        tcpResources = new AtomicReference();
    }
}

