/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.NettyPipeline;
import reactor.ipc.netty.channel.AbortedException;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.http.HttpInfos;

public abstract class HttpOperations<INBOUND extends NettyInbound, OUTBOUND extends NettyOutbound>
extends ChannelOperations<INBOUND, OUTBOUND>
implements HttpInfos {
    volatile int statusAndHeadersSent = 0;
    static final AtomicIntegerFieldUpdater<HttpOperations> HEADERS_SENT = AtomicIntegerFieldUpdater.newUpdater(HttpOperations.class, "statusAndHeadersSent");
    static final ChannelInboundHandler HTTP_EXTRACTOR = NettyPipeline.inboundHandler((ctx, msg) -> {
        if (msg instanceof ByteBufHolder) {
            ByteBuf bb = ((ByteBufHolder)msg).content();
            if (msg instanceof FullHttpMessage) {
                ctx.fireChannelRead(msg);
            } else {
                ctx.fireChannelRead((Object)bb);
                if (msg instanceof LastHttpContent) {
                    ctx.fireChannelRead((Object)LastHttpContent.EMPTY_LAST_CONTENT);
                }
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    });

    protected HttpOperations(Channel ioChannel, HttpOperations<INBOUND, OUTBOUND> replaced) {
        super(ioChannel, replaced);
        this.statusAndHeadersSent = replaced.statusAndHeadersSent;
    }

    protected HttpOperations(Channel ioChannel, BiFunction<? super INBOUND, ? super OUTBOUND, ? extends Publisher<Void>> handler, ContextHandler<?> context) {
        super(ioChannel, handler, context);
    }

    public final boolean hasSentHeaders() {
        return this.statusAndHeadersSent == 1;
    }

    @Override
    public boolean isWebsocket() {
        return false;
    }

    public NettyOutbound sendHeaders() {
        if (this.markHeadersAsSent()) {
            HttpMessage message;
            if (HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage())) {
                this.outboundHttpMessage().headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            }
            if (!(HttpUtil.isTransferEncodingChunked((HttpMessage)this.outboundHttpMessage()) || HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage()) && HttpUtil.getContentLength((HttpMessage)this.outboundHttpMessage(), (int)0) != 0)) {
                if (this.isKeepAlive()) {
                    message = this.newFullEmptyBodyMessage();
                } else {
                    this.markPersistent(false);
                    message = this.outboundHttpMessage();
                }
            } else {
                message = this.outboundHttpMessage();
            }
            return this.then((Publisher)FutureMono.deferFuture(() -> {
                if (!this.channel().isActive()) {
                    throw new AbortedException();
                }
                return this.channel().writeAndFlush((Object)message);
            }));
        }
        return this;
    }

    public Mono<Void> then() {
        if (this.markHeadersAsSent()) {
            if (HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage())) {
                this.outboundHttpMessage().headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            }
            if (!HttpUtil.isTransferEncodingChunked((HttpMessage)this.outboundHttpMessage()) && !HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage())) {
                this.markPersistent(false);
            }
            return FutureMono.deferFuture(() -> this.channel().writeAndFlush((Object)this.outboundHttpMessage()));
        }
        return Mono.empty();
    }

    protected abstract HttpMessage newFullEmptyBodyMessage();

    @Override
    public final NettyOutbound sendFile(Path file, long position, long count) {
        Objects.requireNonNull(file);
        if (this.hasSentHeaders()) {
            return super.sendFile(file, position, count);
        }
        if (!HttpUtil.isTransferEncodingChunked((HttpMessage)this.outboundHttpMessage()) && !HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage()) && count < Integer.MAX_VALUE) {
            this.outboundHttpMessage().headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (int)count);
        } else if (!HttpUtil.isContentLengthSet((HttpMessage)this.outboundHttpMessage())) {
            this.outboundHttpMessage().headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH).remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.outboundHttpMessage(), (boolean)true);
        }
        return super.sendFile(file, position, count);
    }

    @Override
    protected void onInboundCancel() {
        if (!this.isInboundDone()) {
            this.channel().read();
        }
    }

    @Override
    public String toString() {
        if (this.isWebsocket()) {
            return "ws:" + this.uri();
        }
        return this.method().name() + ":" + this.uri();
    }

    @Override
    public HttpOperations<INBOUND, OUTBOUND> addHandler(String name, ChannelHandler handler) {
        super.addHandler(name, handler);
        if (this.channel().pipeline().context(handler) == null) {
            return this;
        }
        HttpOperations.autoAddHttpExtractor(this, name, handler);
        return this;
    }

    static void autoAddHttpExtractor(NettyContext c, String name, ChannelHandler handler) {
        if (handler instanceof ByteToMessageDecoder || handler instanceof ByteToMessageCodec || handler instanceof CombinedChannelDuplexHandler) {
            String extractorName = name + "$extractor";
            if (c.channel().pipeline().context(extractorName) != null) {
                return;
            }
            c.channel().pipeline().addBefore(name, extractorName, (ChannelHandler)HTTP_EXTRACTOR);
            if (NettyContext.isPersistent(c.channel())) {
                c.onClose(() -> c.removeHandler(extractorName));
            }
        }
    }

    protected final boolean markHeadersAsSent() {
        return HEADERS_SENT.compareAndSet(this, 0, 1);
    }

    protected abstract HttpMessage outboundHttpMessage();
}

