/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.client;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.ByteBufFlux;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.http.HttpInfos;
import reactor.ipc.netty.http.multipart.MultipartInbound;
import reactor.ipc.netty.http.websocket.WebsocketInbound;
import reactor.ipc.netty.http.websocket.WebsocketOutbound;

public interface HttpClientResponse
extends NettyInbound,
HttpInfos,
NettyContext {
    @Override
    default public HttpClientResponse addHandlerFirst(ChannelHandler handler) {
        NettyContext.super.addHandlerFirst(handler);
        return this;
    }

    @Override
    public HttpClientResponse addHandlerFirst(String var1, ChannelHandler var2);

    @Override
    default public HttpClientResponse addHandlerLast(ChannelHandler handler) {
        return this.addHandlerLast(handler.getClass().getSimpleName(), handler);
    }

    @Override
    public HttpClientResponse addHandlerLast(String var1, ChannelHandler var2);

    @Override
    default public HttpClientResponse addHandler(ChannelHandler handler) {
        return this.addHandler(handler.getClass().getSimpleName(), handler);
    }

    @Override
    public HttpClientResponse addHandler(String var1, ChannelHandler var2);

    @Override
    public HttpClientResponse removeHandler(String var1);

    @Override
    public HttpClientResponse replaceHandler(String var1, ChannelHandler var2);

    @Override
    public HttpClientResponse onClose(Runnable var1);

    @Override
    default public HttpClientResponse onReadIdle(long idleTimeout, Runnable onReadIdle) {
        NettyInbound.super.onReadIdle(idleTimeout, onReadIdle);
        return this;
    }

    default public Flux<HttpContent> receiveContent() {
        return this.receiveObject().ofType(HttpContent.class);
    }

    default public MultipartInbound receiveMultipart() {
        final HttpClientResponse thiz = this;
        return new MultipartInbound(){

            @Override
            public NettyContext context() {
                return thiz.context();
            }

            @Override
            public Flux<ByteBufFlux> receiveParts() {
                return MultipartInbound.from(thiz);
            }
        };
    }

    public WebsocketInbound receiveWebsocket();

    default public Mono<Void> receiveWebsocket(BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        return this.receiveWebsocket(null, websocketHandler);
    }

    public Mono<Void> receiveWebsocket(String var1, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> var2);

    public String[] redirectedFrom();

    public HttpHeaders responseHeaders();

    public HttpResponseStatus status();
}

