/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.ipc.netty.ByteBufFlux;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.http.client.HttpClientResponse;
import reactor.ipc.netty.http.multipart.MultipartCodec;
import reactor.ipc.netty.http.multipart.MultipartDecoder;

public interface MultipartInbound
extends NettyInbound {
    public static Flux<ByteBufFlux> from(HttpClientResponse inbound) {
        String boundary = MultipartCodec.extractBoundary(inbound.responseHeaders());
        return new MultipartDecoder((Publisher<ByteBuf>)inbound.receive(), boundary, inbound.channel().alloc());
    }

    public Flux<ByteBufFlux> receiveParts();

    @Override
    default public ByteBufFlux receive() {
        return ByteBufFlux.fromInbound(this.receiveParts().onBackpressureError().concatMap(parts -> parts.aggregate().retain()).concatMap(bb -> Flux.using(() -> bb, Flux::just, ReferenceCounted::release)), this.context().channel().alloc());
    }

    @Override
    default public Flux<?> receiveObject() {
        return this.receive();
    }
}

