/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Operators;

final class MultipartTokenizer
implements Subscriber<ByteBuf>,
Subscription {
    static final char[] CRLF = new char[]{'\r', '\n'};
    static final char[] DOUBLE_DASH = new char[]{'-', '-'};
    final char[] boundary;
    final Subscriber<? super Token> actual;
    int bodyPosition;
    Subscription subscription;
    int boundaryPosition;
    ByteBuf byteBuf;
    volatile boolean cancelled = false;
    int crlfPosition;
    int delimiterPosition;
    boolean done = false;
    int doubleDashPosition;
    int position;
    Stage stage;

    MultipartTokenizer(String boundary, Subscriber<? super Token> subscriber) {
        this.actual = subscriber;
        this.boundary = boundary.toCharArray();
        this.reset();
    }

    public final void onSubscribe(Subscription s) {
        if (Operators.validate((Subscription)this.subscription, (Subscription)s)) {
            this.subscription = s;
            this.actual.onSubscribe(s);
        }
    }

    public final void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        Subscription s = this.subscription;
        if (s != null) {
            this.subscription = null;
            s.cancel();
        }
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.actual.onComplete();
    }

    public void onError(Throwable throwable) {
        if (this.done) {
            Operators.onErrorDropped((Throwable)throwable);
            return;
        }
        this.done = true;
        this.actual.onError(throwable);
    }

    public void onNext(ByteBuf byteBuf) {
        if (this.done) {
            Operators.onNextDropped((Object)byteBuf);
            return;
        }
        ByteBuf byteBuf2 = this.byteBuf = this.byteBuf != null ? Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.byteBuf, byteBuf}) : byteBuf;
        while (this.position < this.byteBuf.readableBytes() && !this.cancelled) {
            char c = this.getChar();
            switch (this.stage) {
                case BODY: {
                    this.body(c);
                    break;
                }
                case BOUNDARY: {
                    this.boundary(c);
                    break;
                }
                case END_CRLF: {
                    this.endCrLf(c);
                    break;
                }
                case END_DOUBLE_DASH: {
                    this.endDoubleDash(c);
                    break;
                }
                case START_CRLF: {
                    this.startCrLf(c);
                    break;
                }
                case START_DOUBLE_DASH: {
                    this.startDoubleDash(c);
                    break;
                }
                case TRAILING_CRLF: {
                    this.trailingCrLf(c);
                }
            }
        }
        if (!this.cancelled && Stage.BODY == this.stage) {
            this.pushTrailingBodyToken();
            this.reset();
        }
    }

    public void request(long n) {
        try {
            Operators.checkRequest((long)n);
            if (Integer.MAX_VALUE > n) {
                this.actual.onError(Operators.onOperatorError((Subscription)this, (Throwable)new IllegalArgumentException("This operation only supports unbounded requests, was " + n), (Object)n));
                return;
            }
            Subscription s = this.subscription;
            if (s != null) {
                s.request(n);
            }
        }
        catch (Throwable throwable) {
            this.actual.onError(Operators.onOperatorError((Subscription)this, (Throwable)throwable, (Object)n));
        }
    }

    void body(char c) {
        if (CRLF[0] == c) {
            this.delimiterPosition = this.position++;
            this.stage = Stage.START_CRLF;
            this.crlfPosition = 1;
        } else if (DOUBLE_DASH[0] == c) {
            this.delimiterPosition = this.position++;
            this.stage = Stage.START_DOUBLE_DASH;
            this.doubleDashPosition = 1;
        } else {
            ++this.position;
        }
    }

    void boundary(char c) {
        if (this.boundaryPosition < this.boundary.length) {
            if (this.boundary[this.boundaryPosition] == c) {
                ++this.boundaryPosition;
                ++this.position;
            } else {
                this.stage = Stage.BODY;
            }
        } else if (CRLF[0] == c) {
            this.stage = Stage.END_CRLF;
            this.crlfPosition = 1;
            ++this.position;
        } else if (DOUBLE_DASH[0] == c) {
            this.stage = Stage.END_DOUBLE_DASH;
            this.doubleDashPosition = 1;
            ++this.position;
        } else {
            this.stage = Stage.BODY;
        }
    }

    void endCrLf(char c) {
        if (this.crlfPosition < CRLF.length) {
            if (CRLF[this.crlfPosition] == c) {
                ++this.crlfPosition;
                ++this.position;
            } else {
                this.stage = Stage.BODY;
            }
        } else if (CRLF[0] == c) {
            this.stage = Stage.TRAILING_CRLF;
            this.crlfPosition = 1;
            ++this.position;
        } else {
            this.pushBodyToken();
            this.pushDelimiterToken();
        }
    }

    void endDoubleDash(char c) {
        if (this.doubleDashPosition < DOUBLE_DASH.length) {
            if (DOUBLE_DASH[this.doubleDashPosition] == c) {
                ++this.doubleDashPosition;
                ++this.position;
            } else {
                this.stage = Stage.BODY;
            }
        } else {
            this.pushBodyToken();
            this.pushCloseDelimiterToken();
        }
    }

    char getChar() {
        return (char)(this.byteBuf.getByte(this.position) & 0xFF);
    }

    void pushBodyToken() {
        this.pushToken(TokenKind.BODY, this.bodyPosition, this.delimiterPosition);
        this.bodyPosition = this.position;
    }

    void pushCloseDelimiterToken() {
        this.pushToken(TokenKind.CLOSE_DELIMITER, this.delimiterPosition, this.position);
        this.stage = Stage.BODY;
    }

    void pushDelimiterToken() {
        this.pushToken(TokenKind.DELIMITER, this.delimiterPosition, this.position);
        this.stage = Stage.BODY;
    }

    void pushToken(TokenKind kind, int start, int end) {
        if (!this.cancelled && end - start > 0) {
            this.actual.onNext((Object)new Token(kind, this.byteBuf, start, end - start));
        }
    }

    void pushTrailingBodyToken() {
        this.pushToken(TokenKind.BODY, this.bodyPosition, this.position);
    }

    void reset() {
        this.bodyPosition = 0;
        this.byteBuf = null;
        this.position = 0;
        this.stage = Stage.BODY;
    }

    void startCrLf(char c) {
        if (this.crlfPosition < CRLF.length) {
            if (CRLF[this.crlfPosition] == c) {
                ++this.crlfPosition;
                ++this.position;
            } else {
                this.stage = Stage.BODY;
            }
        } else if (DOUBLE_DASH[0] == c) {
            this.stage = Stage.START_DOUBLE_DASH;
            this.doubleDashPosition = 1;
            ++this.position;
        } else {
            this.stage = Stage.BODY;
        }
    }

    void startDoubleDash(char c) {
        if (this.doubleDashPosition < DOUBLE_DASH.length) {
            if (DOUBLE_DASH[this.doubleDashPosition] == c) {
                ++this.doubleDashPosition;
                ++this.position;
            } else {
                this.stage = Stage.BODY;
            }
        } else if (this.boundary[0] == c) {
            this.stage = Stage.BOUNDARY;
            this.boundaryPosition = 1;
            ++this.position;
        } else {
            this.stage = Stage.BODY;
        }
    }

    void trailingCrLf(char c) {
        if (this.crlfPosition < CRLF.length) {
            if (CRLF[this.crlfPosition] == c) {
                ++this.crlfPosition;
                ++this.position;
            } else {
                this.stage = Stage.BODY;
            }
        } else {
            this.pushBodyToken();
            this.pushDelimiterToken();
        }
    }

    static enum TokenKind {
        BODY,
        CLOSE_DELIMITER,
        DELIMITER;

    }

    static final class Token {
        final ByteBuf byteBuf;
        final TokenKind kind;
        final int length;
        final int offset;

        Token(TokenKind kind, ByteBuf byteBuf, int offset, int length) {
            this.byteBuf = byteBuf;
            this.kind = kind;
            this.length = length;
            this.offset = offset;
        }

        public String toString() {
            return String.format("Token: %s, offset=%d, length=%d, '%s'", new Object[]{this.kind, this.offset, this.length, Token.expandWhitespace(this.byteBuf.toString(this.offset, this.length, Charset.defaultCharset()))});
        }

        ByteBuf getByteBuf() {
            return this.byteBuf.slice(this.offset, this.length);
        }

        TokenKind getKind() {
            return this.kind;
        }

        static String expandWhitespace(String s) {
            return s.replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t");
        }
    }

    static enum Stage {
        BODY,
        BOUNDARY,
        END_CRLF,
        END_DOUBLE_DASH,
        START_CRLF,
        START_DOUBLE_DASH,
        TRAILING_CRLF;

    }
}

