/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.ipc.netty.options.ClientOptions;
import reactor.ipc.netty.resources.LoopResources;
import reactor.ipc.netty.resources.PoolResources;

public final class HttpClientOptions
extends ClientOptions {
    boolean acceptGzip;
    static final SslContext DEFAULT_SSL_CONTEXT;

    public static HttpClientOptions create() {
        return new HttpClientOptions();
    }

    HttpClientOptions() {
    }

    HttpClientOptions(HttpClientOptions options) {
        super(options);
        this.acceptGzip = options.acceptGzip;
    }

    @Override
    public HttpClientOptions afterChannelInit(Consumer<? super Channel> afterChannelInit) {
        super.afterChannelInit(afterChannelInit);
        return this;
    }

    @Override
    public <T> HttpClientOptions attr(AttributeKey<T> key, T value) {
        super.attr(key, value);
        return this;
    }

    @Override
    public HttpClientOptions channelGroup(ChannelGroup channelGroup) {
        super.channelGroup(channelGroup);
        return this;
    }

    @Override
    public HttpClientOptions loopResources(LoopResources eventLoopSelector) {
        super.loopResources(eventLoopSelector);
        return this;
    }

    @Override
    public HttpClientOptions connect(@Nonnull String host, int port) {
        return this.connect(InetSocketAddress.createUnresolved(host, port));
    }

    @Override
    public HttpClientOptions connect(@Nonnull InetSocketAddress connectAddress) {
        super.connect(connectAddress);
        return this;
    }

    @Override
    public HttpClientOptions connect(@Nonnull Supplier<? extends InetSocketAddress> connectAddress) {
        super.connect(connectAddress);
        return this;
    }

    @Override
    public HttpClientOptions disablePool() {
        super.disablePool();
        return this;
    }

    @Override
    public HttpClientOptions duplicate() {
        return new HttpClientOptions(this);
    }

    @Override
    public HttpClientOptions eventLoopGroup(EventLoopGroup eventLoopGroup) {
        super.eventLoopGroup(eventLoopGroup);
        return this;
    }

    public HttpClientOptions compression(boolean enabled) {
        this.acceptGzip = enabled;
        return this;
    }

    public final InetSocketAddress getRemoteAddress(URI uri) {
        Objects.requireNonNull(uri, "uri");
        boolean secure = HttpClientOptions.isSecure(uri);
        int port = uri.getPort() != -1 ? uri.getPort() : (secure ? 443 : 80);
        return this.useProxy() ? InetSocketAddress.createUnresolved(uri.getHost(), port) : new InetSocketAddress(uri.getHost(), port);
    }

    @Override
    public HttpClientOptions onChannelInit(Predicate<? super Channel> onChannelInit) {
        super.onChannelInit(onChannelInit);
        return this;
    }

    @Override
    public <T> HttpClientOptions option(ChannelOption<T> key, T value) {
        super.option(key, value);
        return this;
    }

    @Override
    public HttpClientOptions preferNative(boolean preferNative) {
        super.preferNative(preferNative);
        return this;
    }

    @Override
    public HttpClientOptions poolResources(PoolResources poolResources) {
        super.poolResources(poolResources);
        return this;
    }

    @Override
    public HttpClientOptions protocolFamily(InternetProtocolFamily protocolFamily) {
        super.protocolFamily(protocolFamily);
        return this;
    }

    public HttpClientOptions proxy(@Nonnull String host, int port) {
        return this.proxy(InetSocketAddress.createUnresolved(host, port));
    }

    public HttpClientOptions proxy(@Nonnull String host, int port, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        return this.proxy(InetSocketAddress.createUnresolved(host, port), username, password);
    }

    @Override
    public HttpClientOptions proxy(@Nonnull ClientOptions.Proxy type, @Nonnull String host, int port, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        super.proxy(type, host, port, username, password);
        return this;
    }

    @Override
    public HttpClientOptions proxy(@Nonnull ClientOptions.Proxy type, @Nonnull String host, int port) {
        super.proxy(type, host, port);
        return this;
    }

    @Override
    public HttpClientOptions proxy(@Nonnull ClientOptions.Proxy type, @Nonnull InetSocketAddress connectAddress) {
        super.proxy(type, connectAddress);
        return this;
    }

    @Override
    public HttpClientOptions proxy(@Nonnull ClientOptions.Proxy type, @Nonnull InetSocketAddress connectAddress, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        super.proxy(type, connectAddress, username, password);
        return this;
    }

    @Override
    public HttpClientOptions proxy(@Nonnull ClientOptions.Proxy type, @Nonnull Supplier<? extends InetSocketAddress> connectAddress, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        super.proxy(type, connectAddress, username, password);
        return this;
    }

    public HttpClientOptions proxy(@Nonnull InetSocketAddress connectAddress) {
        super.proxy(ClientOptions.Proxy.HTTP, connectAddress, null, null);
        return this;
    }

    public HttpClientOptions proxy(@Nonnull InetSocketAddress connectAddress, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        super.proxy(ClientOptions.Proxy.HTTP, connectAddress, username, password);
        return this;
    }

    @Override
    public HttpClientOptions proxy(@Nonnull ClientOptions.Proxy type, @Nonnull Supplier<? extends InetSocketAddress> connectAddress) {
        return this.proxy(connectAddress, null, null);
    }

    public HttpClientOptions proxy(@Nonnull Supplier<? extends InetSocketAddress> connectAddress, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        super.proxy(ClientOptions.Proxy.HTTP, connectAddress, username, password);
        return this;
    }

    @Override
    public HttpClientOptions resolver(AddressResolverGroup<?> resolver) {
        super.resolver(resolver);
        return this;
    }

    @Override
    public HttpClientOptions sslContext(SslContext sslContext) {
        super.sslContext(sslContext);
        return this;
    }

    @Override
    public HttpClientOptions sslHandshakeTimeoutMillis(long sslHandshakeTimeoutMillis) {
        super.sslHandshakeTimeoutMillis(sslHandshakeTimeoutMillis);
        return this;
    }

    @Override
    public HttpClientOptions sslHandshakeTimeout(Duration sslHandshakeTimeout) {
        super.sslHandshakeTimeout(sslHandshakeTimeout);
        return this;
    }

    @Override
    public HttpClientOptions sslSupport() {
        super.sslSupport();
        return this;
    }

    @Override
    public HttpClientOptions sslSupport(Consumer<? super SslContextBuilder> configurator) {
        super.sslSupport(configurator);
        return this;
    }

    @Override
    protected SslContext defaultSslContext() {
        return DEFAULT_SSL_CONTEXT;
    }

    final String formatSchemeAndHost(String url, boolean ws) {
        if (!url.startsWith("http") && !url.startsWith("ws")) {
            String scheme = (ws ? "ws" : "http") + "://";
            if (url.startsWith("/")) {
                SocketAddress remote = this.getAddress();
                if (remote != null && !this.useProxy() && remote instanceof InetSocketAddress) {
                    InetSocketAddress inet = (InetSocketAddress)remote;
                    return scheme + inet.getHostName() + ":" + inet.getPort() + url;
                }
                return scheme + "localhost" + url;
            }
            return scheme + url;
        }
        return url;
    }

    static boolean isSecure(URI uri) {
        return uri.getScheme() != null && (uri.getScheme().toLowerCase().equals("https") || uri.getScheme().toLowerCase().equals("wss"));
    }

    static {
        SslContext sslContext;
        try {
            sslContext = SslContextBuilder.forClient().build();
        }
        catch (Exception e) {
            sslContext = null;
        }
        DEFAULT_SSL_CONTEXT = sslContext;
    }
}

