/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpMessage;
import java.util.ArrayDeque;
import java.util.Queue;
import reactor.ipc.netty.NettyPipeline;
import reactor.ipc.netty.http.server.FilteringHttpContentCompressor;

final class CompressionHandler
extends ChannelDuplexHandler {
    final int minResponseSize;
    final Queue<Object> messages = new ArrayDeque<Object>();
    int bodyCompressThreshold;

    CompressionHandler(int minResponseSize) {
        this.minResponseSize = minResponseSize;
        this.bodyCompressThreshold = minResponseSize;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            this.offerByteBuf(ctx, msg, promise);
        } else if (msg instanceof HttpMessage) {
            this.offerHttpMessage(msg, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!(evt != NettyPipeline.responseWriteCompletedEvent() || this.bodyCompressThreshold <= 0 && this.messages.isEmpty())) {
            while (!this.messages.isEmpty()) {
                Object msg = this.messages.poll();
                this.writeSkipCompress(ctx, msg);
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.releaseMsgs();
        super.exceptionCaught(ctx, cause);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.releaseMsgs();
        super.close(ctx, promise);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.addCompressionHandlerOnce(ctx, ctx.pipeline());
    }

    void offerHttpMessage(Object msg, ChannelPromise p) {
        this.messages.offer(msg);
        p.setSuccess();
    }

    void offerByteBuf(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ByteBuf byteBuf = (ByteBuf)msg;
        this.messages.offer(byteBuf);
        if (this.bodyCompressThreshold > 0) {
            this.bodyCompressThreshold -= byteBuf.readableBytes();
        }
        this.drain(ctx, promise);
    }

    void drain(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (this.bodyCompressThreshold <= 0) {
            while (!this.messages.isEmpty()) {
                Object message = this.messages.poll();
                this.writeCompress(ctx, message, promise);
            }
        }
    }

    void writeCompress(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise);
    }

    void writeSkipCompress(ChannelHandlerContext ctx, Object msg) throws Exception {
        ctx.write((Object)FilteringHttpContentCompressor.FilterMessage.wrap(msg));
    }

    void releaseMsgs() {
        while (!this.messages.isEmpty()) {
            Object msg = this.messages.poll();
            if (!(msg instanceof ByteBuf)) continue;
            ((ByteBuf)msg).release();
        }
    }

    void addCompressionHandlerOnce(ChannelHandlerContext ctx, ChannelPipeline cp) {
        if (cp.get(FilteringHttpContentCompressor.class) == null) {
            ctx.pipeline().addBefore("reactor.left.compressionHandler", "reactor.left.compressor", (ChannelHandler)new FilteringHttpContentCompressor());
        }
    }
}

