/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Predicate;
import reactor.ipc.netty.options.ServerOptions;
import reactor.ipc.netty.resources.LoopResources;

public final class HttpServerOptions
extends ServerOptions {
    int minCompressionResponseSize = -1;

    public static HttpServerOptions create() {
        return new HttpServerOptions();
    }

    HttpServerOptions() {
    }

    HttpServerOptions(HttpServerOptions options) {
        super(options);
        this.minCompressionResponseSize = options.minCompressionResponseSize;
    }

    @Override
    public HttpServerOptions afterChannelInit(Consumer<? super Channel> afterChannelInit) {
        super.afterChannelInit(afterChannelInit);
        return this;
    }

    @Override
    public <T> ServerOptions attr(AttributeKey<T> key, T value) {
        super.attr((AttributeKey)key, (Object)value);
        return this;
    }

    @Override
    public HttpServerOptions channelGroup(ChannelGroup channelGroup) {
        super.channelGroup(channelGroup);
        return this;
    }

    @Override
    public HttpServerOptions loopResources(LoopResources eventLoopSelector) {
        super.loopResources(eventLoopSelector);
        return this;
    }

    @Override
    public HttpServerOptions duplicate() {
        return new HttpServerOptions(this);
    }

    @Override
    public HttpServerOptions eventLoopGroup(EventLoopGroup eventLoopGroup) {
        super.eventLoopGroup(eventLoopGroup);
        return this;
    }

    @Override
    public HttpServerOptions listen(String host, int port) {
        super.listen(host, port);
        return this;
    }

    @Override
    public HttpServerOptions listen(InetSocketAddress listenAddress) {
        super.listen(listenAddress);
        return this;
    }

    @Override
    public HttpServerOptions listen(int port) {
        super.listen(port);
        return this;
    }

    @Override
    public HttpServerOptions listen(String host) {
        super.listen(host);
        return this;
    }

    @Override
    public HttpServerOptions onChannelInit(Predicate<? super Channel> onChannelInit) {
        super.onChannelInit(onChannelInit);
        return this;
    }

    @Override
    public <T> HttpServerOptions option(ChannelOption<T> key, T value) {
        super.option((ChannelOption)key, (Object)value);
        return this;
    }

    @Override
    public <T> HttpServerOptions selectorAttr(AttributeKey<T> key, T value) {
        super.selectorAttr(key, value);
        return this;
    }

    @Override
    public <T> HttpServerOptions selectorOption(ChannelOption<T> key, T value) {
        super.selectorOption(key, value);
        return this;
    }

    @Override
    public HttpServerOptions preferNative(boolean preferNative) {
        super.preferNative(preferNative);
        return this;
    }

    @Override
    public HttpServerOptions sslContext(SslContext sslContext) {
        super.sslContext(sslContext);
        return this;
    }

    @Override
    public HttpServerOptions sslHandshakeTimeout(Duration sslHandshakeTimeout) {
        super.sslHandshakeTimeout(sslHandshakeTimeout);
        return this;
    }

    @Override
    public HttpServerOptions sslHandshakeTimeoutMillis(long sslHandshakeTimeoutMillis) {
        super.sslHandshakeTimeoutMillis(sslHandshakeTimeoutMillis);
        return this;
    }

    @Override
    public HttpServerOptions sslSelfSigned(Consumer<? super SslContextBuilder> configurator) {
        super.sslSelfSigned(configurator);
        return this;
    }

    @Override
    public HttpServerOptions sslSelfSigned() {
        super.sslSelfSigned();
        return this;
    }

    public HttpServerOptions compression(boolean enabled) {
        this.minCompressionResponseSize = enabled ? 0 : -1;
        return this;
    }

    public HttpServerOptions compression(int minResponseSize) {
        if (minResponseSize < 0) {
            throw new IllegalArgumentException("minResponseSize should be non-negative");
        }
        this.minCompressionResponseSize = 0;
        return this;
    }
}

