/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.options;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import reactor.ipc.netty.resources.LoopResources;
import reactor.util.function.Tuple2;

public abstract class NettyOptions<BOOSTRAP extends AbstractBootstrap<BOOSTRAP, ?>, SO extends NettyOptions<BOOSTRAP, SO>>
implements Supplier<BOOSTRAP> {
    public static final int DEFAULT_PORT = System.getenv("PORT") != null ? Integer.parseInt(System.getenv("PORT")) : 12012;
    final BOOSTRAP bootstrapTemplate;
    boolean preferNative = DEFAULT_NATIVE;
    LoopResources loopResources = null;
    ChannelGroup channelGroup = null;
    SslContext sslContext = null;
    long sslHandshakeTimeoutMillis = 10000L;
    long sslCloseNotifyFlushTimeoutMillis = 3000L;
    long sslCloseNotifyReadTimeoutMillis = 0L;
    Consumer<? super Channel> afterChannelInit = null;
    Consumer<? super Channel> afterChannelInitUser = null;
    Predicate<? super Channel> onChannelInit = null;
    static final boolean DEFAULT_NATIVE = Boolean.parseBoolean(System.getProperty("reactor.ipc.netty.epoll", "true"));

    static void defaultNettyOptions(AbstractBootstrap<?, ?> bootstrap) {
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
    }

    NettyOptions(BOOSTRAP bootstrapTemplate) {
        this.bootstrapTemplate = bootstrapTemplate;
        NettyOptions.defaultNettyOptions(bootstrapTemplate);
    }

    NettyOptions(NettyOptions<BOOSTRAP, ?> options) {
        this.bootstrapTemplate = options.bootstrapTemplate.clone();
        this.sslHandshakeTimeoutMillis = options.sslHandshakeTimeoutMillis;
        this.sslCloseNotifyFlushTimeoutMillis = options.sslCloseNotifyFlushTimeoutMillis;
        this.sslCloseNotifyReadTimeoutMillis = options.sslCloseNotifyReadTimeoutMillis;
        this.sslContext = options.sslContext;
        this.afterChannelInit = options.afterChannelInit;
        this.afterChannelInitUser = options.afterChannelInitUser;
        this.onChannelInit = options.onChannelInit;
        this.channelGroup = options.channelGroup;
        this.loopResources = options.loopResources;
        this.preferNative = options.preferNative;
    }

    public final Consumer<? super Channel> afterChannelInit() {
        return this.afterChannelInitUser;
    }

    public SO afterChannelInit(Consumer<? super Channel> afterChannelInit) {
        Objects.requireNonNull(afterChannelInit, "afterChannelInit");
        this.afterChannelInitUser = afterChannelInit;
        this.afterChannelInit = this.channelGroup != null ? c -> {
            afterChannelInit.accept((Channel)c);
            this.channelGroup.add(c);
        } : afterChannelInit;
        return (SO)this;
    }

    public <T> SO attr(AttributeKey<T> key, T value) {
        this.bootstrapTemplate.attr(key, value);
        return (SO)this;
    }

    public SO channelGroup(ChannelGroup channelGroup) {
        Objects.requireNonNull(channelGroup, "channelGroup");
        this.channelGroup = channelGroup;
        Consumer<? super Channel> c = this.afterChannelInitUser;
        if (c != null) {
            this.afterChannelInit(c);
        } else {
            this.afterChannelInit = arg_0 -> channelGroup.add(arg_0);
        }
        return (SO)this;
    }

    public SO loopResources(LoopResources channelResources) {
        Objects.requireNonNull(channelResources, "loopResources");
        this.loopResources = channelResources;
        return (SO)this;
    }

    public abstract SO duplicate();

    public SO eventLoopGroup(EventLoopGroup eventLoopGroup) {
        Objects.requireNonNull(eventLoopGroup, "eventLoopGroup");
        return this.loopResources(preferNative -> eventLoopGroup);
    }

    @Override
    public BOOSTRAP get() {
        return (BOOSTRAP)this.bootstrapTemplate.clone();
    }

    public abstract SocketAddress getAddress();

    public final LoopResources getLoopResources() {
        return this.loopResources;
    }

    public final SslHandler getSslHandler(ByteBufAllocator allocator, Tuple2<String, Integer> sniInfo) {
        SslContext sslContext;
        SslContext sslContext2 = sslContext = this.sslContext == null ? this.defaultSslContext() : this.sslContext;
        if (sslContext == null) {
            return null;
        }
        Objects.requireNonNull(allocator, "allocator");
        SslHandler sslHandler = sniInfo != null && sniInfo.getT1() != null && sniInfo.getT2() != null ? sslContext.newHandler(allocator, (String)sniInfo.getT1(), ((Integer)sniInfo.getT2()).intValue()) : sslContext.newHandler(allocator);
        sslHandler.setHandshakeTimeoutMillis(this.sslHandshakeTimeoutMillis);
        sslHandler.setCloseNotifyFlushTimeoutMillis(this.sslCloseNotifyFlushTimeoutMillis);
        sslHandler.setCloseNotifyReadTimeoutMillis(this.sslCloseNotifyReadTimeoutMillis);
        return sslHandler;
    }

    public final Predicate<? super Channel> onChannelInit() {
        return this.onChannelInit;
    }

    public SO onChannelInit(Predicate<? super Channel> onChannelInit) {
        this.onChannelInit = Objects.requireNonNull(onChannelInit, "onChannelInit");
        return (SO)this;
    }

    public <T> SO option(ChannelOption<T> key, T value) {
        this.bootstrapTemplate.option(key, value);
        return (SO)this;
    }

    public SO preferNative(boolean preferNative) {
        this.preferNative = preferNative;
        return (SO)this;
    }

    public final boolean preferNative() {
        return this.preferNative;
    }

    public SO sslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return (SO)this;
    }

    protected SslContext defaultSslContext() {
        return null;
    }

    public SO sslHandshakeTimeout(Duration sslHandshakeTimeout) {
        Objects.requireNonNull(sslHandshakeTimeout, "sslHandshakeTimeout");
        return this.sslHandshakeTimeoutMillis(sslHandshakeTimeout.toMillis());
    }

    public SO sslHandshakeTimeoutMillis(long sslHandshakeTimeoutMillis) {
        if (sslHandshakeTimeoutMillis < 0L) {
            throw new IllegalArgumentException("ssl handshake timeout must be positive, was: " + sslHandshakeTimeoutMillis);
        }
        this.sslHandshakeTimeoutMillis = sslHandshakeTimeoutMillis;
        return (SO)this;
    }

    public SO sslCloseNotifyFlushTimeout(Duration sslCloseNotifyFlushTimeout) {
        Objects.requireNonNull(sslCloseNotifyFlushTimeout, "sslCloseNotifyFlushTimeout");
        return this.sslCloseNotifyFlushTimeoutMillis(sslCloseNotifyFlushTimeout.toMillis());
    }

    public SO sslCloseNotifyFlushTimeoutMillis(long sslCloseNotifyFlushTimeoutMillis) {
        if (sslCloseNotifyFlushTimeoutMillis < 0L) {
            throw new IllegalArgumentException("ssl close_notify flush timeout must be positive, was: " + sslCloseNotifyFlushTimeoutMillis);
        }
        this.sslCloseNotifyFlushTimeoutMillis = sslCloseNotifyFlushTimeoutMillis;
        return (SO)this;
    }

    public SO sslCloseNotifyReadTimeout(Duration sslCloseNotifyReadTimeout) {
        Objects.requireNonNull(sslCloseNotifyReadTimeout, "sslCloseNotifyReadTimeout");
        return this.sslCloseNotifyFlushTimeoutMillis(sslCloseNotifyReadTimeout.toMillis());
    }

    public SO sslCloseNotifyReadTimeoutMillis(long sslCloseNotifyReadTimeoutMillis) {
        if (sslCloseNotifyReadTimeoutMillis < 0L) {
            throw new IllegalArgumentException("ssl close_notify read timeout must be positive, was: " + sslCloseNotifyReadTimeoutMillis);
        }
        this.sslCloseNotifyReadTimeoutMillis = sslCloseNotifyReadTimeoutMillis;
        return (SO)this;
    }

    public String toString() {
        return "NettyOptions{bootstrapTemplate=" + this.bootstrapTemplate + ", sslHandshakeTimeoutMillis=" + this.sslHandshakeTimeoutMillis + ", sslCloseNotifyFlushTimeoutMillis=" + this.sslCloseNotifyFlushTimeoutMillis + ", sslCloseNotifyReadTimeoutMillis=" + this.sslCloseNotifyReadTimeoutMillis + ", sslContext=" + this.sslContext + ", preferNative=" + this.preferNative + ", afterChannelInit=" + this.afterChannelInit + ", onChannelInit=" + this.onChannelInit + ", loopResources=" + this.loopResources + '}';
    }
}

