/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.NetUtil;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyConnector;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.http.HttpResources;
import reactor.ipc.netty.http.server.CompressionHandler;
import reactor.ipc.netty.http.server.HttpServerHandler;
import reactor.ipc.netty.http.server.HttpServerOperations;
import reactor.ipc.netty.http.server.HttpServerOptions;
import reactor.ipc.netty.http.server.HttpServerRequest;
import reactor.ipc.netty.http.server.HttpServerResponse;
import reactor.ipc.netty.http.server.HttpServerRoutes;
import reactor.ipc.netty.options.ServerOptions;
import reactor.ipc.netty.tcp.TcpServer;

public final class HttpServer
implements NettyConnector<HttpServerRequest, HttpServerResponse> {
    final TcpBridgeServer server;
    final HttpServerOptions options;
    static final LoggingHandler loggingHandler = new LoggingHandler(HttpServer.class);

    public static HttpServer create() {
        return HttpServer.create(NetUtil.LOCALHOST.getHostAddress());
    }

    public static HttpServer create(Consumer<? super HttpServerOptions> options) {
        Objects.requireNonNull(options, "options");
        HttpServerOptions serverOptions = HttpServerOptions.create();
        options.accept(serverOptions);
        if (!serverOptions.isLoopAvailable()) {
            serverOptions.loopResources(HttpResources.get());
        }
        return new HttpServer(serverOptions.duplicate());
    }

    public static HttpServer create(int port) {
        return HttpServer.create("0.0.0.0", port);
    }

    public static HttpServer create(String bindAddress) {
        return HttpServer.create(bindAddress, 80);
    }

    public static HttpServer create(String bindAddress, int port) {
        return HttpServer.create((? super HttpServerOptions opts) -> opts.listen(bindAddress, port));
    }

    HttpServer(HttpServerOptions options) {
        this.server = new TcpBridgeServer(options);
        this.options = options;
    }

    public Mono<? extends NettyContext> newHandler(BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        Objects.requireNonNull(handler, "handler");
        return this.server.newHandler(handler);
    }

    public Mono<? extends NettyContext> newRouter(Consumer<? super HttpServerRoutes> routesBuilder) {
        Objects.requireNonNull(routesBuilder, "routeBuilder");
        HttpServerRoutes routes = HttpServerRoutes.newRoutes();
        routesBuilder.accept(routes);
        return this.newHandler(routes);
    }

    final class TcpBridgeServer
    extends TcpServer
    implements BiConsumer<ChannelPipeline, ContextHandler<Channel>> {
        TcpBridgeServer(ServerOptions options) {
            super(options);
        }

        @Override
        protected ContextHandler<Channel> doHandler(BiFunction<? super NettyInbound, ? super NettyOutbound, ? extends Publisher<Void>> handler, MonoSink<NettyContext> sink) {
            return ContextHandler.newServerContext(sink, HttpServer.this.options, loggingHandler, (ch, c, msg) -> HttpServerOperations.bindHttp(ch, handler, c, msg)).onPipeline(this).autoCreateOperations(false);
        }

        @Override
        public void accept(ChannelPipeline p, ContextHandler<Channel> c) {
            p.addLast("reactor.left.httpDecoder", (ChannelHandler)new HttpRequestDecoder()).addLast("reactor.left.httpEncoder", (ChannelHandler)new HttpResponseEncoder());
            if (HttpServer.this.options.minCompressionResponseSize >= 0) {
                p.addLast("reactor.left.compressionHandler", (ChannelHandler)new CompressionHandler(HttpServer.this.options.minCompressionResponseSize));
            }
            p.addLast("reactor.left.httpServerHandler", (ChannelHandler)new HttpServerHandler(c));
        }

        @Override
        protected LoggingHandler loggingHandler() {
            return loggingHandler;
        }
    }
}

