/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.options;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.core.Exceptions;
import reactor.ipc.netty.options.NettyOptions;
import reactor.ipc.netty.resources.LoopResources;
import reactor.ipc.netty.resources.PoolResources;

public class ClientOptions
extends NettyOptions<Bootstrap, ClientOptions> {
    PoolResources poolResources;
    boolean poolDisabled = false;
    String proxyUsername;
    Function<? super String, ? extends String> proxyPassword;
    Supplier<? extends InetSocketAddress> proxyAddress;
    Proxy proxyType;
    InternetProtocolFamily protocolFamily = null;
    Supplier<? extends SocketAddress> connectAddress = null;

    public static ClientOptions create() {
        return new ClientOptions();
    }

    static void defaultClientOptions(Bootstrap bootstrap) {
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)30000)).option(ChannelOption.AUTO_READ, (Object)false)).option(ChannelOption.SO_RCVBUF, (Object)0x100000)).option(ChannelOption.SO_SNDBUF, (Object)0x100000);
    }

    protected ClientOptions() {
        this(new Bootstrap());
    }

    protected ClientOptions(Bootstrap bootstrap) {
        super(bootstrap);
        ClientOptions.defaultClientOptions(bootstrap);
    }

    protected ClientOptions(ClientOptions options) {
        super(options);
        this.proxyUsername = options.proxyUsername;
        this.proxyPassword = options.proxyPassword;
        this.proxyAddress = options.proxyAddress;
        this.proxyType = options.proxyType;
        this.connectAddress = options.connectAddress;
        this.poolResources = options.poolResources;
        this.protocolFamily = options.protocolFamily;
    }

    public ClientOptions connect(int port) {
        return this.connect(new InetSocketAddress(NetUtil.LOCALHOST.getHostAddress(), port));
    }

    public ClientOptions connect(@Nonnull String host, int port) {
        return this.connect(InetSocketAddress.createUnresolved(host, port));
    }

    public ClientOptions connect(@Nonnull InetSocketAddress connectAddress) {
        return this.connect(() -> connectAddress);
    }

    public ClientOptions connect(@Nonnull Supplier<? extends InetSocketAddress> connectAddress) {
        this.connectAddress = Objects.requireNonNull(connectAddress, "connectAddress");
        return this;
    }

    public ClientOptions disablePool() {
        this.poolResources = null;
        this.poolDisabled = true;
        return this;
    }

    public final boolean isPoolDisabled() {
        return this.poolDisabled;
    }

    public final boolean isPoolAvailable() {
        return this.poolResources != null;
    }

    @Override
    public ClientOptions duplicate() {
        return new ClientOptions(this);
    }

    @Override
    public Bootstrap get() {
        Bootstrap b = (Bootstrap)super.get();
        this.groupAndChannel(b);
        return b;
    }

    @Override
    public final SocketAddress getAddress() {
        return this.connectAddress == null ? null : this.connectAddress.get();
    }

    public final PoolResources getPoolResources() {
        return this.poolResources;
    }

    public final ProxyHandler getProxyHandler() {
        if (this.proxyType == null) {
            return null;
        }
        InetSocketAddress proxyAddr = this.proxyAddress.get();
        String username = this.proxyUsername;
        String password = username != null && this.proxyPassword != null ? this.proxyPassword.apply(username) : null;
        switch (this.proxyType) {
            case HTTP: {
                return username != null && password != null ? new HttpProxyHandler((SocketAddress)proxyAddr, username, password) : new HttpProxyHandler((SocketAddress)proxyAddr);
            }
            case SOCKS4: {
                return username != null ? new Socks4ProxyHandler((SocketAddress)proxyAddr, username) : new Socks4ProxyHandler((SocketAddress)proxyAddr);
            }
            case SOCKS5: {
                return username != null && password != null ? new Socks5ProxyHandler((SocketAddress)proxyAddr, username, password) : new Socks5ProxyHandler((SocketAddress)proxyAddr);
            }
        }
        throw new IllegalArgumentException("Proxy type unsupported : " + (Object)((Object)this.proxyType));
    }

    public ClientOptions poolResources(PoolResources poolResources) {
        Objects.requireNonNull(poolResources, "poolResources");
        this.poolResources = poolResources;
        this.poolDisabled = false;
        return this;
    }

    public ClientOptions protocolFamily(InternetProtocolFamily protocolFamily) {
        Objects.requireNonNull(protocolFamily, "protocolFamily");
        this.protocolFamily = protocolFamily;
        return this;
    }

    public ClientOptions proxy(@Nonnull Proxy type, @Nonnull String host, int port, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        return this.proxy(type, InetSocketAddress.createUnresolved(host, port), username, password);
    }

    public ClientOptions proxy(@Nonnull Proxy type, @Nonnull String host, int port) {
        return this.proxy(type, InetSocketAddress.createUnresolved(host, port));
    }

    public ClientOptions proxy(@Nonnull Proxy type, @Nonnull InetSocketAddress connectAddress) {
        return this.proxy(type, connectAddress, null, null);
    }

    public ClientOptions proxy(@Nonnull Proxy type, @Nonnull InetSocketAddress connectAddress, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        return this.proxy(type, connectAddress.isUnresolved() ? () -> new InetSocketAddress(connectAddress.getHostName(), connectAddress.getPort()) : () -> connectAddress, username, password);
    }

    public ClientOptions proxy(@Nonnull Proxy type, @Nonnull Supplier<? extends InetSocketAddress> connectAddress) {
        return this.proxy(type, connectAddress, null, null);
    }

    public ClientOptions proxy(@Nonnull Proxy type, @Nonnull Supplier<? extends InetSocketAddress> connectAddress, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        this.proxyUsername = username;
        this.proxyPassword = password;
        this.proxyAddress = Objects.requireNonNull(connectAddress, "addressSupplier");
        this.proxyType = Objects.requireNonNull(type, "proxyType");
        if (((Bootstrap)this.bootstrapTemplate).config().resolver() == DefaultAddressResolverGroup.INSTANCE) {
            this.resolver((AddressResolverGroup<?>)NoopAddressResolverGroup.INSTANCE);
        }
        return this;
    }

    public ClientOptions resolver(AddressResolverGroup<?> resolver) {
        Objects.requireNonNull(resolver, "resolver");
        ((Bootstrap)this.bootstrapTemplate).resolver(resolver);
        return this;
    }

    public ClientOptions sslSupport() {
        return this.sslSupport(c -> {});
    }

    public ClientOptions sslSupport(Consumer<? super SslContextBuilder> configurator) {
        Objects.requireNonNull(configurator, "configurator");
        try {
            SslContextBuilder builder = SslContextBuilder.forClient();
            configurator.accept((SslContextBuilder)builder);
            return (ClientOptions)this.sslContext(builder.build());
        }
        catch (Exception sslException) {
            throw Exceptions.bubble((Throwable)sslException);
        }
    }

    protected boolean useDatagramChannel() {
        return false;
    }

    protected boolean useProxy() {
        return this.proxyType != null;
    }

    final void groupAndChannel(Bootstrap bootstrap) {
        LoopResources loops = Objects.requireNonNull(this.loopResources, "loopResources");
        boolean useNative = this.protocolFamily == null && this.preferNative && !(this.sslContext instanceof JdkSslContext);
        EventLoopGroup elg = loops.onClient(useNative);
        if (this.poolResources != null && elg instanceof Supplier) {
            bootstrap.group((EventLoopGroup)((Supplier)elg).get());
        } else {
            bootstrap.group(elg);
        }
        if (this.useDatagramChannel()) {
            if (useNative) {
                bootstrap.channel(loops.onDatagramChannel(elg));
            } else {
                bootstrap.channelFactory(() -> new NioDatagramChannel(this.protocolFamily));
            }
        } else {
            bootstrap.channel(loops.onChannel(elg));
        }
    }

    public static enum Proxy {
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

