/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.socket.DatagramChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Schedulers;
import reactor.ipc.netty.NettyConnector;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.options.ClientOptions;
import reactor.ipc.netty.options.NettyOptions;
import reactor.ipc.netty.resources.LoopResources;
import reactor.ipc.netty.udp.UdpClientOptions;
import reactor.ipc.netty.udp.UdpInbound;
import reactor.ipc.netty.udp.UdpOperations;
import reactor.ipc.netty.udp.UdpOutbound;

public final class UdpClient
implements NettyConnector<UdpInbound, UdpOutbound> {
    final UdpClientOptions options;
    static final int DEFAULT_UDP_THREAD_COUNT = Integer.parseInt(System.getProperty("reactor.udp.ioThreadCount", "" + Schedulers.DEFAULT_POOL_SIZE));
    static final LoggingHandler loggingHandler = new LoggingHandler(UdpClient.class);
    static final LoopResources DEFAULT_UDP_LOOPS = LoopResources.create("udp", DEFAULT_UDP_THREAD_COUNT, true);

    public static UdpClient create() {
        return UdpClient.create(NetUtil.LOCALHOST.getHostAddress());
    }

    public static UdpClient create(String bindAddress) {
        return UdpClient.create(bindAddress, NettyOptions.DEFAULT_PORT);
    }

    public static UdpClient create(int port) {
        return UdpClient.create(NetUtil.LOCALHOST.getHostAddress(), port);
    }

    public static UdpClient create(String bindAddress, int port) {
        return UdpClient.create((? super ClientOptions opts) -> opts.connect(bindAddress, port));
    }

    public static UdpClient create(Consumer<? super ClientOptions> options) {
        Objects.requireNonNull(options, "options");
        UdpClientOptions clientOptions = new UdpClientOptions();
        options.accept(clientOptions);
        if (!clientOptions.isLoopAvailable()) {
            clientOptions.loopResources(DEFAULT_UDP_LOOPS);
        }
        return new UdpClient(clientOptions.duplicate());
    }

    UdpClient(UdpClientOptions options) {
        this.options = Objects.requireNonNull(options, "options");
    }

    public Mono<? extends NettyContext> newHandler(BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler) {
        BiFunction<Object, Object, Object> targetHandler = null == handler ? ChannelOperations.noopHandler() : handler;
        return Mono.create((T sink) -> {
            Bootstrap b = this.options.get();
            SocketAddress adr = this.options.getAddress();
            if (adr == null) {
                sink.error((Throwable)new NullPointerException("Provided ClientOptions do not define any address to bind to "));
                return;
            }
            b.localAddress(adr);
            ContextHandler<DatagramChannel> c = this.doHandler(targetHandler, (MonoSink<NettyContext>)sink, adr);
            b.handler(c);
            c.setFuture((Future<?>)b.bind());
        });
    }

    protected ContextHandler<DatagramChannel> doHandler(BiFunction<? super UdpInbound, ? super UdpOutbound, ? extends Publisher<Void>> handler, MonoSink<NettyContext> sink, SocketAddress providedAddress) {
        return ContextHandler.newClientContext(sink, this.options, loggingHandler, false, providedAddress, (ch, c, msg) -> UdpOperations.bind(ch, handler, c));
    }
}

