/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public abstract class FutureMono
extends Mono<Void> {
    public static <F extends Future<Void>> Mono<Void> from(F future) {
        if (future.isDone()) {
            if (!future.isSuccess()) {
                return Mono.error((Throwable)future.cause());
            }
            return Mono.empty();
        }
        return new ImmediateFutureMono<F>(future);
    }

    public static <F extends Future<Void>> Mono<Void> deferFuture(Supplier<F> deferredFuture) {
        return new DeferredFutureMono<F>(deferredFuture);
    }

    static final class FutureSubscription<F extends Future<Void>>
    implements GenericFutureListener<F>,
    Subscription {
        final CoreSubscriber<? super Void> s;
        final F future;

        FutureSubscription(F future, CoreSubscriber<? super Void> s) {
            this.s = s;
            this.future = future;
        }

        public void request(long n) {
        }

        public void cancel() {
            this.future.removeListener((GenericFutureListener)this);
        }

        public void operationComplete(F future) throws Exception {
            if (!future.isSuccess()) {
                this.s.onError(future.cause());
            } else {
                this.s.onComplete();
            }
        }
    }

    static final class DeferredFutureMono<F extends Future<Void>>
    extends FutureMono {
        final Supplier<F> deferredFuture;

        DeferredFutureMono(Supplier<F> deferredFuture) {
            this.deferredFuture = Objects.requireNonNull(deferredFuture, "deferredFuture");
        }

        public void subscribe(CoreSubscriber<? super Void> s) {
            Future f = (Future)this.deferredFuture.get();
            if (f == null) {
                Operators.error(s, (Throwable)Operators.onOperatorError((Throwable)new NullPointerException("Deferred supplied null"), (Context)s.currentContext()));
                return;
            }
            if (f.isDone()) {
                if (f.isSuccess()) {
                    Operators.complete(s);
                } else {
                    Operators.error(s, (Throwable)f.cause());
                }
                return;
            }
            FutureSubscription<Future> fs = new FutureSubscription<Future>(f, s);
            s.onSubscribe(fs);
            f.addListener(fs);
        }
    }

    static final class ImmediateFutureMono<F extends Future<Void>>
    extends FutureMono {
        final F future;

        ImmediateFutureMono(F future) {
            this.future = (Future)Objects.requireNonNull(future, "future");
        }

        public final void subscribe(CoreSubscriber<? super Void> s) {
            if (this.future.isDone()) {
                if (this.future.isSuccess()) {
                    Operators.complete(s);
                } else {
                    Operators.error(s, (Throwable)this.future.cause());
                }
                return;
            }
            FutureSubscription<F> fs = new FutureSubscription<F>(this.future, s);
            s.onSubscribe(fs);
            this.future.addListener(fs);
        }
    }
}

