/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.options;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.Exceptions;
import reactor.ipc.netty.options.ClientProxyOptions;
import reactor.ipc.netty.options.NettyOptions;
import reactor.ipc.netty.resources.LoopResources;
import reactor.ipc.netty.resources.PoolResources;

public class ClientOptions
extends NettyOptions<Bootstrap, ClientOptions> {
    private final PoolResources poolResources;
    private final ClientProxyOptions proxyOptions;
    private final InternetProtocolFamily protocolFamily;
    private final Supplier<? extends SocketAddress> connectAddress;

    public static <BUILDER extends Builder<BUILDER>> Builder<BUILDER> builder() {
        return ClientOptions.builder(new Bootstrap());
    }

    public static <BUILDER extends Builder<BUILDER>> Builder<BUILDER> builder(Bootstrap bootstrap) {
        return new Builder(bootstrap);
    }

    protected ClientOptions(Builder<?> builder) {
        super(builder);
        this.proxyOptions = ((Builder)builder).proxyOptions;
        this.connectAddress = Objects.isNull(((Builder)builder).connectAddress) ? (((Builder)builder).port >= 0 ? (Objects.isNull(((Builder)builder).host) ? () -> new InetSocketAddress(NetUtil.LOCALHOST.getHostAddress(), ((Builder)builder).port) : () -> InetSocketAddress.createUnresolved(((Builder)builder).host, ((Builder)builder).port)) : null) : ((Builder)builder).connectAddress;
        this.poolResources = ((Builder)builder).poolResources;
        this.protocolFamily = ((Builder)builder).protocolFamily;
    }

    @Override
    public ClientOptions duplicate() {
        return ((Builder)ClientOptions.builder().from(this)).build();
    }

    @Override
    public Bootstrap get() {
        Bootstrap b = (Bootstrap)super.get();
        this.groupAndChannel(b);
        return b;
    }

    @Override
    public final SocketAddress getAddress() {
        return this.connectAddress == null ? null : this.connectAddress.get();
    }

    public final PoolResources getPoolResources() {
        return this.poolResources;
    }

    public final ClientProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    protected boolean useDatagramChannel() {
        return false;
    }

    public boolean useProxy(SocketAddress address) {
        if (this.proxyOptions != null) {
            if (this.proxyOptions.getNonProxyHosts() != null && address instanceof InetSocketAddress) {
                String hostName = ((InetSocketAddress)address).getHostName();
                return !this.proxyOptions.getNonProxyHosts().matcher(hostName).matches();
            }
            return true;
        }
        return false;
    }

    public boolean useProxy(String hostName) {
        if (this.proxyOptions != null) {
            if (this.proxyOptions.getNonProxyHosts() != null && hostName != null) {
                return !this.proxyOptions.getNonProxyHosts().matcher(hostName).matches();
            }
            return true;
        }
        return false;
    }

    final void groupAndChannel(Bootstrap bootstrap) {
        LoopResources loops = Objects.requireNonNull(this.getLoopResources(), "loopResources");
        boolean useNative = this.protocolFamily == null && this.preferNative() && !(this.sslContext() instanceof JdkSslContext);
        EventLoopGroup elg = loops.onClient(useNative);
        if (this.poolResources != null && elg instanceof Supplier) {
            bootstrap.group((EventLoopGroup)((Supplier)elg).get());
        } else {
            bootstrap.group(elg);
        }
        if (this.useDatagramChannel()) {
            if (useNative) {
                bootstrap.channel(loops.onDatagramChannel(elg));
            } else {
                bootstrap.channelFactory(() -> new NioDatagramChannel(this.protocolFamily));
            }
        } else {
            bootstrap.channel(loops.onChannel(elg));
        }
    }

    @Override
    public String asSimpleString() {
        StringBuilder s = new StringBuilder();
        if (this.getAddress() == null) {
            s.append("connecting to no base address");
        } else {
            s.append("connecting to ").append(this.getAddress());
        }
        if (this.proxyOptions != null) {
            s.append(" through ").append((Object)this.proxyOptions.getType()).append(" proxy");
        }
        return s.toString();
    }

    @Override
    public String asDetailedString() {
        if (this.proxyOptions == null) {
            return "connectAddress=" + this.getAddress() + ", proxy=null, " + super.asDetailedString();
        }
        return "connectAddress=" + this.getAddress() + ", " + this.proxyOptions.asSimpleString() + ", " + super.asDetailedString();
    }

    @Override
    public String toString() {
        return "ClientOptions{" + this.asDetailedString() + "}";
    }

    public static class Builder<BUILDER extends Builder<BUILDER>>
    extends NettyOptions.Builder<Bootstrap, ClientOptions, BUILDER> {
        private PoolResources poolResources;
        private boolean poolDisabled = false;
        private InternetProtocolFamily protocolFamily;
        private String host;
        private int port = -1;
        private Supplier<? extends SocketAddress> connectAddress;
        private ClientProxyOptions proxyOptions;

        protected Builder(Bootstrap bootstrapTemplate) {
            super(bootstrapTemplate);
            this.defaultClientOptions(bootstrapTemplate);
        }

        private void defaultClientOptions(Bootstrap bootstrap) {
            ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)30000)).option(ChannelOption.AUTO_READ, (Object)false)).option(ChannelOption.SO_RCVBUF, (Object)0x100000)).option(ChannelOption.SO_SNDBUF, (Object)0x100000);
        }

        public final BUILDER resolver(AddressResolverGroup<?> resolver) {
            Objects.requireNonNull(resolver, "resolver");
            ((Bootstrap)this.bootstrapTemplate).resolver(resolver);
            return (BUILDER)this.get();
        }

        public final BUILDER poolResources(PoolResources poolResources) {
            this.poolResources = Objects.requireNonNull(poolResources, "poolResources");
            this.poolDisabled = false;
            return (BUILDER)this.get();
        }

        public BUILDER disablePool() {
            this.poolResources = null;
            this.poolDisabled = true;
            return (BUILDER)this.get();
        }

        public final boolean isPoolDisabled() {
            return this.poolDisabled;
        }

        public final boolean isPoolAvailable() {
            return this.poolResources != null;
        }

        public final BUILDER protocolFamily(InternetProtocolFamily protocolFamily) {
            this.protocolFamily = Objects.requireNonNull(protocolFamily, "protocolFamily");
            return (BUILDER)this.get();
        }

        public final BUILDER sslSupport() {
            return this.sslSupport(c -> {});
        }

        public final BUILDER sslSupport(Consumer<? super SslContextBuilder> configurator) {
            Objects.requireNonNull(configurator, "configurator");
            try {
                SslContextBuilder builder = SslContextBuilder.forClient();
                configurator.accept((SslContextBuilder)builder);
                return (BUILDER)((Builder)this.sslContext(builder.build()));
            }
            catch (Exception sslException) {
                throw Exceptions.bubble((Throwable)sslException);
            }
        }

        public final BUILDER host(String host) {
            this.host = Objects.isNull(host) ? NetUtil.LOCALHOST.getHostAddress() : host;
            return (BUILDER)this.get();
        }

        public final BUILDER port(int port) {
            this.port = Objects.requireNonNull(Integer.valueOf(port), "port");
            return (BUILDER)this.get();
        }

        public final BUILDER connectAddress(Supplier<? extends SocketAddress> connectAddressSupplier) {
            this.connectAddress = Objects.requireNonNull(connectAddressSupplier, "connectAddressSupplier");
            return (BUILDER)this.get();
        }

        public final BUILDER proxy(Function<ClientProxyOptions.TypeSpec, ClientProxyOptions.Builder> proxyOptions) {
            Objects.requireNonNull(proxyOptions, "proxyOptions");
            ClientProxyOptions.Builder builder = proxyOptions.apply(ClientProxyOptions.builder());
            this.proxyOptions = builder.build();
            if (((Bootstrap)this.bootstrapTemplate).config().resolver() == DefaultAddressResolverGroup.INSTANCE) {
                this.resolver((AddressResolverGroup<?>)NoopAddressResolverGroup.INSTANCE);
            }
            return (BUILDER)this.get();
        }

        @Override
        public final BUILDER from(ClientOptions options) {
            super.from(options);
            this.proxyOptions = options.proxyOptions;
            this.connectAddress = options.connectAddress;
            this.poolResources = options.poolResources;
            this.protocolFamily = options.protocolFamily;
            return (BUILDER)this.get();
        }

        @Override
        public BUILDER get() {
            return (BUILDER)this;
        }

        public ClientOptions build() {
            return new ClientOptions(this);
        }
    }
}

