/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.http.server;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.FutureMono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.ReactorNetty;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.ContextHandler;
import reactor.ipc.netty.http.Cookies;
import reactor.ipc.netty.http.HttpOperations;
import reactor.ipc.netty.http.server.HttpServerRequest;
import reactor.ipc.netty.http.server.HttpServerResponse;
import reactor.ipc.netty.http.server.HttpServerWSOperations;
import reactor.ipc.netty.http.server.SimpleCompressionHandler;
import reactor.ipc.netty.http.websocket.WebsocketInbound;
import reactor.ipc.netty.http.websocket.WebsocketOutbound;
import reactor.util.Logger;
import reactor.util.Loggers;

class HttpServerOperations
extends HttpOperations<HttpServerRequest, HttpServerResponse>
implements HttpServerRequest,
HttpServerResponse {
    final HttpResponse nettyResponse;
    final HttpHeaders responseHeaders;
    final Cookies cookieHolder;
    final HttpRequest nettyRequest;
    final BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate;
    Function<? super String, Map<String, String>> paramsResolver;
    static final Logger log = Loggers.getLogger(HttpServerOperations.class);
    static final AsciiString EVENT_STREAM = new AsciiString((CharSequence)"text/event-stream");
    static final FullHttpResponse CONTINUE = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE, Unpooled.EMPTY_BUFFER);

    static HttpServerOperations bindHttp(Channel channel, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler, ContextHandler<?> context, BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate, Object msg) {
        return new HttpServerOperations(channel, handler, context, compressionPredicate, (HttpRequest)msg);
    }

    HttpServerOperations(Channel ch, HttpServerOperations replaced) {
        super(ch, replaced);
        this.cookieHolder = replaced.cookieHolder;
        this.responseHeaders = replaced.responseHeaders;
        this.nettyResponse = replaced.nettyResponse;
        this.paramsResolver = replaced.paramsResolver;
        this.nettyRequest = replaced.nettyRequest;
        this.compressionPredicate = replaced.compressionPredicate;
    }

    HttpServerOperations(Channel ch, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler, ContextHandler<?> context, BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate, HttpRequest nettyRequest) {
        super(ch, handler, context);
        this.nettyRequest = Objects.requireNonNull(nettyRequest, "nettyRequest");
        this.nettyResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        this.responseHeaders = this.nettyResponse.headers();
        this.compressionPredicate = compressionPredicate;
        this.cookieHolder = Cookies.newServerRequestHolder(this.requestHeaders());
        this.chunkedTransfer(true);
    }

    @Override
    public HttpServerOperations context(Consumer<NettyContext> contextCallback) {
        contextCallback.accept(this.context());
        return this;
    }

    @Override
    protected HttpMessage newFullEmptyBodyMessage() {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(this.version(), this.status(), Unpooled.EMPTY_BUFFER);
        if (!HttpMethod.HEAD.equals((Object)this.method())) {
            this.responseHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            if (!HttpResponseStatus.NOT_MODIFIED.equals((Object)this.status())) {
                this.responseHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0);
            }
        }
        res.headers().set(this.responseHeaders);
        this.markPersistent(true);
        return res;
    }

    @Override
    public HttpServerResponse addCookie(Cookie cookie) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.STRICT.encode(cookie));
        return this;
    }

    @Override
    public HttpServerResponse addHeader(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public HttpServerResponse chunkedTransfer(boolean chunked) {
        if (!this.hasSentHeaders() && HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyResponse) != chunked) {
            this.responseHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.nettyResponse, (boolean)chunked);
        }
        return this;
    }

    @Override
    public Map<CharSequence, Set<Cookie>> cookies() {
        if (this.cookieHolder != null) {
            return this.cookieHolder.getCachedCookies();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpServerResponse header(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.set(name, (Object)value);
        return this;
    }

    @Override
    public HttpServerResponse headers(HttpHeaders headers) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.responseHeaders.set(headers);
        return this;
    }

    @Override
    public boolean isKeepAlive() {
        return HttpUtil.isKeepAlive((HttpMessage)this.nettyRequest);
    }

    @Override
    public boolean isWebsocket() {
        return this.requestHeaders().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true) && HttpResponseStatus.SWITCHING_PROTOCOLS.equals((Object)this.status());
    }

    @Override
    public HttpServerResponse keepAlive(boolean keepAlive) {
        HttpUtil.setKeepAlive((HttpMessage)this.nettyResponse, (boolean)keepAlive);
        return this;
    }

    @Override
    public HttpMethod method() {
        return this.nettyRequest.method();
    }

    @Override
    public String param(CharSequence key) {
        Objects.requireNonNull(key, "key");
        Map<String, String> params = null;
        if (this.paramsResolver != null) {
            params = this.paramsResolver.apply(this.uri());
        }
        return null != params ? (String)params.get(key) : null;
    }

    @Override
    public Map<String, String> params() {
        return null != this.paramsResolver ? this.paramsResolver.apply(this.uri()) : null;
    }

    @Override
    public HttpServerRequest paramsResolver(Function<? super String, Map<String, String>> headerResolver) {
        this.paramsResolver = headerResolver;
        return this;
    }

    @Override
    public Flux<?> receiveObject() {
        if (HttpUtil.is100ContinueExpected((HttpMessage)this.nettyRequest)) {
            return FutureMono.deferFuture(() -> {
                if (!this.hasSentHeaders()) {
                    return this.channel().writeAndFlush((Object)CONTINUE);
                }
                return this.channel().newSucceededFuture();
            }).thenMany(super.receiveObject());
        }
        return super.receiveObject();
    }

    @Override
    public HttpHeaders requestHeaders() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.headers();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpHeaders responseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public Mono<Void> send() {
        if (this.markSentHeaderAndBody()) {
            HttpMessage response = this.newFullEmptyBodyMessage();
            return FutureMono.deferFuture(() -> this.channel().writeAndFlush((Object)response));
        }
        return Mono.empty();
    }

    @Override
    public NettyOutbound sendFile(Path file) {
        try {
            return this.sendFile(file, 0L, Files.size(file));
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Path not resolved"), (Throwable)e);
            }
            return this.then((Publisher<Void>)this.sendNotFound());
        }
    }

    @Override
    public Mono<Void> sendNotFound() {
        return this.status(HttpResponseStatus.NOT_FOUND).send();
    }

    @Override
    public Mono<Void> sendRedirect(String location) {
        Objects.requireNonNull(location, "location");
        return this.status(HttpResponseStatus.FOUND).header((CharSequence)HttpHeaderNames.LOCATION, location).send();
    }

    @Override
    public HttpServerResponse sse() {
        this.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)EVENT_STREAM);
        return this;
    }

    @Override
    public HttpResponseStatus status() {
        return HttpResponseStatus.valueOf((int)this.nettyResponse.status().code());
    }

    @Override
    public HttpServerResponse status(HttpResponseStatus status) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.nettyResponse.setStatus(status);
        return this;
    }

    @Override
    public Mono<Void> sendWebsocket(String protocols, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        return this.withWebsocketSupport(this.uri(), protocols, websocketHandler);
    }

    @Override
    public String uri() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.uri();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpVersion version() {
        if (this.nettyRequest != null) {
            return this.nettyRequest.protocolVersion();
        }
        throw new IllegalStateException("request not parsed");
    }

    @Override
    public HttpServerResponse compression(boolean compress) {
        if (!compress) {
            this.removeHandler("reactor.left.compressionHandler");
        } else if (this.channel().pipeline().get("reactor.left.compressionHandler") == null) {
            SimpleCompressionHandler handler = new SimpleCompressionHandler();
            try {
                handler.channelRead(this.channel().pipeline().context("reactor.right.reactiveBridge"), this.nettyRequest);
                this.addHandlerFirst("reactor.left.compressionHandler", (ChannelHandler)handler);
            }
            catch (Throwable e) {
                log.error(ReactorNetty.format(this.channel(), ""), e);
            }
        }
        return this;
    }

    @Override
    protected void onHandlerStart() {
        this.applyHandler();
    }

    @Override
    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpContent) {
            if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
                super.onInboundNext(ctx, msg);
            }
            if (msg instanceof LastHttpContent) {
                this.onInboundComplete();
                if (!this.isKeepAlive()) {
                    this.channel().config().setAutoRead(true);
                }
            }
        } else {
            super.onInboundNext(ctx, msg);
        }
    }

    @Override
    protected void preSendHeadersAndStatus() {
        if (!HttpUtil.isTransferEncodingChunked((HttpMessage)this.nettyResponse) && !HttpUtil.isContentLengthSet((HttpMessage)this.nettyResponse)) {
            this.markPersistent(false);
        }
        if (HttpResponseStatus.NOT_MODIFIED.equals((Object)this.status())) {
            this.responseHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING).remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        }
        if (this.compressionPredicate != null && this.compressionPredicate.test(this, this)) {
            this.compression(true);
        }
    }

    @Override
    protected void onOutboundComplete() {
        ChannelFuture f;
        if (this.isWebsocket()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), "Last HTTP response frame"));
        }
        if (this.markSentHeaderAndBody()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "No sendHeaders() called before complete, sending zero-length header"));
            }
            f = this.channel().writeAndFlush((Object)this.newFullEmptyBodyMessage());
        } else if (this.markSentBody()) {
            f = this.channel().writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        } else {
            this.discard();
            return;
        }
        f.addListener(s -> {
            this.discard();
            if (!s.isSuccess() && log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Failed flushing last frame"), s.cause());
            }
        });
    }

    static void cleanHandlerTerminate(Channel ch) {
        ChannelOperations<?, ?> ops = HttpServerOperations.get(ch);
        if (ops == null) {
            return;
        }
        ((HttpServerOperations)ops).onHandlerTerminate();
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (!this.channel().isActive()) {
            super.onOutboundError(err);
            return;
        }
        if (this.markSentHeaders()) {
            log.error(ReactorNetty.format(this.channel(), "Error starting response. Replying error status"), err);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, 0).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            this.channel().writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        this.markSentBody();
        this.channel().writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    @Override
    protected HttpMessage outboundHttpMessage() {
        return this.nettyResponse;
    }

    final Mono<Void> withWebsocketSupport(String url, String protocols, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> websocketHandler) {
        Objects.requireNonNull(websocketHandler, "websocketHandler");
        if (this.markSentHeaders()) {
            HttpServerWSOperations ops = new HttpServerWSOperations(url, protocols, this);
            if (this.replace(ops)) {
                return FutureMono.from(ops.handshakerResult).doOnSuccess(aVoid -> Mono.from((Publisher)((Publisher)websocketHandler.apply(ops, ops))).doAfterSuccessOrError((BiConsumer)ops).subscribe());
            }
        } else {
            log.error(ReactorNetty.format(this.channel(), "Cannot enable websocket if headers have already been sent"));
        }
        return Mono.error((Throwable)new IllegalStateException("Failed to upgrade to websocket"));
    }
}

