/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.channel.AbortedException;
import reactor.ipc.netty.channel.ChannelOperations;
import reactor.ipc.netty.channel.CloseableContextHandler;
import reactor.ipc.netty.options.ServerOptions;

final class ServerContextHandler
extends CloseableContextHandler<Channel>
implements NettyContext {
    final ServerOptions serverOptions;

    ServerContextHandler(ChannelOperations.OnNew<Channel> channelOpFactory, ServerOptions options, MonoSink<NettyContext> sink, LoggingHandler loggingHandler, SocketAddress providedAddress) {
        super(channelOpFactory, options, sink, loggingHandler, providedAddress);
        this.serverOptions = options;
    }

    @Override
    protected void doStarted(Channel channel) {
        this.sink.success((Object)this);
    }

    @Override
    public final void fireContextActive(NettyContext context) {
    }

    @Override
    public void fireContextError(Throwable err) {
        if (AbortedException.isConnectionReset(err)) {
            if (log.isDebugEnabled()) {
                log.debug("Connection closed remotely", err);
            }
        } else if (log.isErrorEnabled()) {
            log.error("Handler failure while no child channelOperation was present", err);
        }
    }

    @Override
    public InetSocketAddress address() {
        return ((ServerSocketChannel)this.f.channel()).localAddress();
    }

    @Override
    public NettyContext onClose(Runnable onClose) {
        this.onClose().subscribe(null, e -> onClose.run(), onClose);
        return this;
    }

    @Override
    public Channel channel() {
        return this.f.channel();
    }

    @Override
    public boolean isDisposed() {
        return !this.f.channel().isActive();
    }

    @Override
    public void terminateChannel(Channel channel) {
        if (!this.f.channel().isActive()) {
            return;
        }
        if (!NettyContext.isPersistent(channel)) {
            channel.close();
        }
    }

    @Override
    protected void doPipeline(Channel ch) {
        ServerContextHandler.addSslAndLogHandlers(this.options, this, this.loggingHandler, true, this.getSNI(), ch.pipeline());
    }
}

