/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver.internals;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import reactor.kafka.receiver.ReceiverPartition;
import reactor.util.annotation.Nullable;

class SeekablePartition
implements ReceiverPartition {
    private final Consumer<?, ?> consumer;
    private final TopicPartition topicPartition;

    public SeekablePartition(Consumer<?, ?> consumer, TopicPartition topicPartition) {
        this.consumer = consumer;
        this.topicPartition = topicPartition;
    }

    @Override
    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    public void seekToBeginning() {
        this.consumer.seekToBeginning(Collections.singletonList(this.topicPartition));
    }

    @Override
    public void seekToEnd() {
        this.consumer.seekToEnd(Collections.singletonList(this.topicPartition));
    }

    @Override
    public void seek(long offset) {
        this.consumer.seek(this.topicPartition, offset);
    }

    @Override
    public void seekToTimestamp(long timestamp) {
        Map offsets = this.consumer.offsetsForTimes(Collections.singletonMap(this.topicPartition, timestamp));
        OffsetAndTimestamp next = (OffsetAndTimestamp)offsets.values().iterator().next();
        if (next == null) {
            this.seekToEnd();
        } else {
            this.consumer.seek(this.topicPartition, next.offset());
        }
    }

    @Override
    public long position() {
        return this.consumer.position(this.topicPartition);
    }

    @Override
    @Nullable
    public Long beginningOffset() {
        Map beginningOffsets = this.consumer.beginningOffsets(Collections.singleton(this.topicPartition));
        return beginningOffsets == null ? null : (Long)beginningOffsets.get(this.topicPartition);
    }

    @Override
    @Nullable
    public Long endOffset() {
        Map endOffsets = this.consumer.endOffsets(Collections.singleton(this.topicPartition));
        return endOffsets == null ? null : (Long)endOffsets.get(this.topicPartition);
    }

    public String toString() {
        return String.valueOf(this.topicPartition);
    }
}

