/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver;

import io.micrometer.observation.ObservationRegistry;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;
import reactor.core.scheduler.Scheduler;
import reactor.kafka.receiver.ImmutableReceiverOptions;
import reactor.kafka.receiver.ReceiverPartition;
import reactor.kafka.receiver.observation.KafkaReceiverObservationConvention;
import reactor.util.annotation.NonNull;
import reactor.util.annotation.Nullable;

public interface ReceiverOptions<K, V> {
    @NonNull
    public static <K, V> ReceiverOptions<K, V> create() {
        return new ImmutableReceiverOptions();
    }

    @NonNull
    public static <K, V> ReceiverOptions<K, V> create(@NonNull Map<String, Object> configProperties) {
        return new ImmutableReceiverOptions(configProperties);
    }

    @NonNull
    public static <K, V> ReceiverOptions<K, V> create(@NonNull Properties configProperties) {
        return new ImmutableReceiverOptions(configProperties);
    }

    @NonNull
    public ReceiverOptions<K, V> consumerProperty(@NonNull String var1, @NonNull Object var2);

    @NonNull
    public ReceiverOptions<K, V> withKeyDeserializer(@NonNull Deserializer<K> var1);

    @NonNull
    public ReceiverOptions<K, V> withValueDeserializer(@NonNull Deserializer<V> var1);

    @NonNull
    public ReceiverOptions<K, V> pollTimeout(@NonNull Duration var1);

    @NonNull
    public ReceiverOptions<K, V> closeTimeout(@NonNull Duration var1);

    @NonNull
    public ReceiverOptions<K, V> addAssignListener(@NonNull java.util.function.Consumer<Collection<ReceiverPartition>> var1);

    @NonNull
    public ReceiverOptions<K, V> addRevokeListener(@NonNull java.util.function.Consumer<Collection<ReceiverPartition>> var1);

    @NonNull
    public ReceiverOptions<K, V> clearAssignListeners();

    @NonNull
    public ReceiverOptions<K, V> clearRevokeListeners();

    @NonNull
    public ReceiverOptions<K, V> assignment(Collection<TopicPartition> var1);

    @NonNull
    public ReceiverOptions<K, V> subscription(Collection<String> var1);

    @NonNull
    public ReceiverOptions<K, V> subscription(Pattern var1);

    @NonNull
    public ReceiverOptions<K, V> commitInterval(Duration var1);

    @NonNull
    public ReceiverOptions<K, V> commitBatchSize(int var1);

    @NonNull
    public ReceiverOptions<K, V> atmostOnceCommitAheadSize(int var1);

    @NonNull
    public ReceiverOptions<K, V> maxCommitAttempts(int var1);

    @NonNull
    public ReceiverOptions<K, V> commitRetryInterval(Duration var1);

    default public ReceiverOptions<K, V> maxDeferredCommits(int maxDeferred) {
        return this;
    }

    default public ReceiverOptions<K, V> maxDelayRebalance(Duration maxDelay) {
        return this;
    }

    default public ReceiverOptions<K, V> pauseAllAfterRebalance(boolean pauseAll) {
        return this;
    }

    default public ReceiverOptions<K, V> commitIntervalDuringDelay(long interval) {
        return this;
    }

    @NonNull
    public ReceiverOptions<K, V> schedulerSupplier(Supplier<Scheduler> var1);

    default public ReceiverOptions<K, V> consumerListener(@Nullable ConsumerListener listener) {
        return this;
    }

    @NonNull
    default public ReceiverOptions<K, V> withObservation(@NonNull ObservationRegistry observationRegistry) {
        return this.withObservation(observationRegistry, null);
    }

    @NonNull
    public ReceiverOptions<K, V> withObservation(@NonNull ObservationRegistry var1, @Nullable KafkaReceiverObservationConvention var2);

    @NonNull
    public Map<String, Object> consumerProperties();

    @Nullable
    public Object consumerProperty(@NonNull String var1);

    @Nullable
    public Deserializer<K> keyDeserializer();

    @Nullable
    public Deserializer<V> valueDeserializer();

    @NonNull
    public Duration pollTimeout();

    @NonNull
    public Duration closeTimeout();

    @NonNull
    public List<java.util.function.Consumer<Collection<ReceiverPartition>>> assignListeners();

    @NonNull
    public List<java.util.function.Consumer<Collection<ReceiverPartition>>> revokeListeners();

    @Nullable
    public Collection<TopicPartition> assignment();

    @Nullable
    public Collection<String> subscriptionTopics();

    @Nullable
    public Pattern subscriptionPattern();

    @Nullable
    public String groupId();

    @NonNull
    public Duration heartbeatInterval();

    @NonNull
    public Duration commitInterval();

    @NonNull
    public int commitBatchSize();

    @NonNull
    public int atmostOnceCommitAheadSize();

    @NonNull
    public int maxCommitAttempts();

    @NonNull
    public Duration commitRetryInterval();

    default public int maxDeferredCommits() {
        return 0;
    }

    default public Duration maxDelayRebalance() {
        return Duration.ofSeconds(60L);
    }

    default public boolean pauseAllAfterRebalance() {
        return false;
    }

    default public long commitIntervalDuringDelay() {
        return 100L;
    }

    @NonNull
    public Supplier<Scheduler> schedulerSupplier();

    @Nullable
    default public ConsumerListener consumerListener() {
        return null;
    }

    @NonNull
    public ObservationRegistry observationRegistry();

    @Nullable
    public KafkaReceiverObservationConvention observationConvention();

    @Nullable
    default public String clientId() {
        return (String)this.consumerProperty("client.id");
    }

    @NonNull
    default public String bootstrapServers() {
        Object bootstrapServers = Objects.requireNonNull(this.consumerProperty("bootstrap.servers"));
        if (bootstrapServers instanceof List) {
            List listOfBootstrapServers = (List)bootstrapServers;
            return String.join((CharSequence)",", listOfBootstrapServers);
        }
        return (String)bootstrapServers;
    }

    @NonNull
    default public java.util.function.Consumer<Consumer<K, V>> subscriber(@NonNull ConsumerRebalanceListener listener) {
        Objects.requireNonNull(listener);
        if (this.subscriptionTopics() != null) {
            return consumer -> consumer.subscribe(this.subscriptionTopics(), listener);
        }
        if (this.subscriptionPattern() != null) {
            return consumer -> consumer.subscribe(this.subscriptionPattern(), listener);
        }
        if (this.assignment() != null) {
            return consumer -> {
                consumer.assign(this.assignment());
                listener.onPartitionsAssigned(this.assignment());
            };
        }
        throw new IllegalStateException("No subscriptions have been created");
    }

    public static interface ConsumerListener {
        default public void consumerAdded(String id, Consumer<?, ?> consumer) {
        }

        default public void consumerRemoved(String id, Consumer<?, ?> consumer) {
        }
    }
}

